import sys

input_file = 'pandoc_output.html'
output_file = 'mathjax_ready.html'
if len(sys.argv) >= 2:
    input_file = sys.argv[1]
if len(sys.argv) >= 3:
    output_file = sys.argv[2]

# Pandocの出力（<body>の中身）を読み込む
with open(input_file, 'r', encoding='utf-8') as f:
    body_content = f.read()

# MathJax対応のHTMLとしてラップ
html_template = f"""<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
  <script id="MathJax-script" async
    src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/mml-chtml.js"></script>
</head>
<body>
{body_content}
</body>
</html>
"""

# 保存
with open(output_file, 'w', encoding='utf-8') as f:
    f.write(html_template)

print(f"整形完了！{output_file} に保存しました。")
