# correct_pandoc_html.py のドキュメント

このプログラムは、Pandoc の出力（HTML の body 部分）を取り込み、MathJax が利用できるようにするための簡易ラッピングを行います。出力は外部 CDN の MathJax を読み込む HTML テンプレートで包んだファイルを生成します。

---

## 1) プログラムの動作

- デフォルト入力ファイル: `pandoc_output.html`
- デフォルト出力ファイル: `mathjax_ready.html`
- 動作の流れ:
  1. コマンドライン引数で入力ファイル名を受け取る。指定がなければ `pandoc_output.html`。
  2. コマンドライン引数で出力ファイル名を受け取る。指定がなければ `mathjax_ready.html`。
  3. 入力ファイルを UTF-8 で読み込み、内容を変数 `body_content` に格納。
  4. MathJax 用の HTML テンプレートに、読み込んだ `body_content` を挿入。
     - テンプレートには MathJax 用の CDN（MathJax 3.x、mml-chtml.js）と、ES6 の polyfill が含まれる。
  5. テンプレートを出力ファイルに UTF-8 で保存。
  6. 「整形完了！{出力ファイル名} に保存しました。」と標準出力へ表示。

- 注意点:
  - 入力ファイルは Pandoc の出力としての HTML の「body」部分を想定している。もし入力ファイルが完全な HTML ドキュメント（<html>〜</html> 全体）であった場合、body の中に全体が入る形になり、構造が不適切になることがあります。Pandoc で出力された body 部分を想定して使用してください。

---

## 2) 必要な非標準ライブラリとインストール方法

- このスクリプトは Python の標準ライブラリだけで動作します。非標準ライブラリは必要ありません。
- 実行環境の要件:
  - Python 3.x がインストールされていること。

- インストール手順:
  - Python が未インストールの場合:
    - Windows: https://www.python.org/downloads/ から Python をダウンロードしてインストール
    - macOS: Homebrew がある場合は `brew install python`、その他は公式サイトからインストーラを利用
    - Linux: ディストリビューションのパッケージマネージャで `python3` をインストール（例: Debian/Ubuntu なら `sudo apt-get install python3`）
  - 追加のライブラリは不要なので、特別なセットアップは不要です。

---

## 3) 必要な入力ファイル

- デフォルト入力ファイル: `pandoc_output.html`
- 入力ファイルの形式について:
  - Pandoc の HTML 出力（body 部分）を想定しています。
  - ファイルは UTF-8 エンコーディングで保存してください。
- コマンドラインで入力ファイルを指定する場合:
  - 例: `python correct_pandoc_html.py my_pandoc_body.html`

- 入力ファイルが不要な場合や別のファイル名を使いたい場合は、実行時に第1引数としてファイル名を指定します。

---

## 4) 実行後に生成される出力ファイル

- デフォルト出力ファイル: `mathjax_ready.html`
- 出力ファイルの内容:
  - HTML ドキュメントとして、以下の要素を含む全体の HTML。
    - ヘッド内に MathJax 用の CDN スクリプトと polyfill のスクリプトを読み込み
    - ボディには入力ファイルの内容（bodyContent）がそのまま挿入された構造
- 出力ファイルの例名:
  - `mathjax_ready.html`
- 実行が成功すると、標準出力に次のメッセージが表示されます:
  - 整形完了！<出力ファイル名> に保存しました。

---

## 5) コマンドラインでの使用例（Usage）

- 基本的な使い方（デフォルト設定を使用）:
  - Windows/macOS/Linux 共通
    - python3 を使用して実行する場合:
      - python3 correct_pandoc_html.py
    - これにより `pandoc_output.html` を入力として `mathjax_ready.html` が生成されます。

- 入力ファイル/出力ファイルを指定する場合:
  - 入力ファイルを `my_pandoc_body.html`、出力ファイルを `my_mathjax_ready.html` にする:
    - python3 correct_pandoc_html.py my_pandoc_body.html my_mathjax_ready.html

- 注意:
  - 入力ファイル名を省略した場合は `pandoc_output.html`、出力ファイル名を省略した場合は `mathjax_ready.html` が使用されます。

---

このドキュメントが、プログラムの動作理解と実行手順の参照に役立つことを願います。必要に応じて、追加のオプションやエラーハンドリングの拡張案もお知らせください。