# プログラムドキュメント: `convert_office_files.py`

## 1) プログラムの動作
このプログラムは、指定された入力ファイル（PowerPoint、Word、PDF、テキスト、HTMLなど）を画像（PNG、JPG）、PDF、Markdown形式に変換するツールです。コマンドライン引数を使用して、入力ファイルのパス、出力ディレクトリ、出力フォーマットを指定できます。プログラムは、指定されたディレクトリ内で入力ファイルを検索し、見つかったファイルを変換します。

## 2) 必要な非標準ライブラリとインストールコマンド
以下の非標準ライブラリが必要です。これらは、Pythonのパッケージ管理ツールである`pip`を使用してインストールできます。

```bash
pip install convert2md txt2pdf pptx2pdf pptx2img pptx2md docx2img pdf2img img2pdf
```

`html2pdf`ライブラリはオプションであり、インストールされていない場合でもプログラムは動作しますが、HTMLファイルのPDF変換機能は使用できません。

## 3) 必要な入力ファイル
プログラムは以下の形式のファイルを入力として受け付けます：
- PowerPointファイル（.pptx）
- Wordファイル（.docx）
- PDFファイル（.pdf）
- テキストファイル（.txt）
- Markdownファイル（.md）
- HTMLファイル（.html, .htm）

デフォルトの入力ファイルは `41-01-search_MP.pptx` です。

## 4) 実行後に生成される出力ファイル
出力ファイルは指定されたフォーマットに応じて生成されます。サポートされている出力フォーマットは以下の通りです：
- 画像（PNG、JPG）
- PDF
- Markdown（.md）

出力ファイルは指定された出力ディレクトリに保存されます。

## 5) コマンドラインでの使用例 (Usage)
以下は、プログラムのコマンドラインでの使用例です。

```bash
python convert_office_files.py --infile <入力ファイルのパス> --output_dir <出力ディレクトリのパス> --output_format <出力フォーマット>
```

### 例
```bash
python convert_office_files.py --infile example.pptx --output_dir output_images --output_format png
```

このコマンドは、`example.pptx`をPNG形式の画像に変換し、`output_images`ディレクトリに保存します。