#https://okumuralab.org/~okumura/python/markitdown.html
#https://self-development.info/markitdown%e5%85%a5%e9%96%80-%e3%82%b7%e3%83%b3%e3%83%97%e3%83%ab%e3%81%a7%e5%8a%b9%e7%8e%87%e7%9a%84%e3%81%aa%e6%96%87%e6%9b%b8%e5%a4%89%e6%8f%9b%e3%83%84%e3%83%bc%e3%83%ab/

#https://blog.beachside.dev/entry/2024/12/17/120000
#画像解析に必要: Azure API
#AOAI_ENDPOINT=xxx
#AOAI_API_KEY =xxxx
#AOAI_API_VERSION=2024-10-21
#AOAI_DEPLOYMENT_CHAT=xxxxx

import os
import sys
from types import SimpleNamespace
try:
    from dotenv import load_dotenv, find_dotenv
except:
    print("\npptx2pdf_recursive.py: Import error: dotenv")
    input("Install: pip install dotenv\n")
try:
    from markitdown import MarkItDown
except:
    print("\npptx2pdf_recursive.py: Import error: markitdown")
    input("Install: pip inistall markitdown\n")
    input("Install: pip inistall markitdown[docx]\n")
    input("Install: pip inistall markitdown[pptx]\n")
    input("Install: pip inistall markitdown[pdf]\n")
try:
    from openai import OpenAI
except:
    print("\npptx2pdf_recursive.py: Import error: openai")
    input("Install: pip inistall openai\n")


def initialize():
    cfg = SimpleNamespace()
    # 環境変数の読み込み
#    if not find_dotenv():
#        terminate("Error: .envファイルが見つかりません。")
    load_dotenv()
    cfg.OPENAI_API_KEY = os.getenv("OPENAI_API_KEY")
    if not cfg.OPENAI_API_KEY:
        print("\nWarning: OPENAI_API_KEYが設定されていません\n")
#        terminate("Error: OPENAI_API_KEYが設定されていません。")
    return cfg

def replace_path(path, ext):
    if not path:
        terminate("Error: 入力パスが空です。")
    return os.path.splitext(path)[0] + ext

def save(path, text):
    if not text:
        terminate("Error: 保存するテキストが空です。")
    try:
        with open(path, "w", encoding="utf-8") as file:
            file.write(text)
    except IOError:
        terminate(f"Error: ファイル {path} の保存に失敗しました。")

def update_vars(cfg, args):
    if len(args) > 1:
        cfg.infile = args[1]
        if not os.path.exists(cfg.infile):
            terminate(f"Error: ファイル {cfg.infile} が存在しません。")
    else:
        terminate("Error: 入力ファイルが指定されていません。")
    return cfg

def convert_to_md(infile, cfg):
    # OpenAIクライアントの初期化
    if cfg.OPENAI_API_KEY:
        client = OpenAI()
    else:
        client = None

    if not infile:
        terminate("Error: 入力ファイルが無効です。")

    # MarkItDownの設定
    if ".jpg" in infile.lower():
        print(f"Analyze image file {infile}")
        md = MarkItDown(mlm_client=client, mlm_model="gpt-4o-mini")
        result = md.convert(infile, mlm_prompt="画像について説明してください。")
    else:
        print(f"Analyze {infile}")
        md = MarkItDown()
        result = md.convert(infile)

    if not result.text_content:
        terminate("Error: 変換結果が空です。")

    return result.text_content

def convert(infile, outfile):
    cfg = initialize()
    filename_without_ext = os.path.splitext(os.path.basename(infile))[0]
    if outfile is None:
        outfile = os.path.join(os.path.dirname(infile), f"{filename_without_ext}.md")

    text = convert_to_md(infile, cfg)
    print(f"Save to {outfile}")
    save(outfile, text)

def usage():
    print("\nUSAGE:")
    print("  python script.py <input_file>")
    print("  <input_file>: The path to the input file to be converted to markdown.\n")

def terminate(message):
    print(message)
    usage()
    sys.exit(1)

def main():
    cfg = initialize()
    cfg = update_vars(cfg, sys.argv)

    outfile = replace_path(cfg.infile, '.md')
    print("\nConvert document file to markdown file")
    print(f"infile: {cfg.infile}")
    print(f"outfile: {outfile}")

    text = convert_to_md(cfg.infile, cfg)
    print(text)

    print(f"Save to {outfile}")
    save(outfile, text)

    usage()

if __name__ == "__main__":
    main()
