# convert2md.py Documentation

## 1. プログラムの動作
`convert2md.py`は、指定された入力ファイル（画像または文書）をMarkdown形式に変換するPythonスクリプトです。OpenAIのAPIを利用して、画像の内容を解析し、Markdown形式のテキストを生成します。変換されたテキストは指定された出力ファイルに保存されます。

## 2. 必要な非標準ライブラリとインストールコマンド
このプログラムは以下の非標準ライブラリを使用しています。

- `dotenv`
- `markitdown`
- `openai`

### インストール方法
以下のコマンドを使用して、必要なライブラリをインストールできます。

```bash
pip install python-dotenv
pip install markitdown
pip install markitdown[docx]
pip install markitdown[pptx]
pip install markitdown[pdf]
pip install openai
```

## 3. 必要な入力ファイル
プログラムは以下の形式の入力ファイルを受け付けます。

- 画像ファイル（例: `.jpg`）
- 文書ファイル（例: `.docx`, `.pptx`, `.pdf`）

入力ファイルはコマンドライン引数として指定する必要があります。

## 4. 実行後に生成される出力ファイル
プログラムは、指定された入力ファイルと同じディレクトリに、拡張子が`.md`のMarkdownファイルを生成します。出力ファイル名は、入力ファイル名から拡張子を除いたものに`.md`を付加したものになります。

## 5. コマンドラインでの使用例 (Usage)
プログラムは以下のようにコマンドラインから実行します。

```bash
python convert2md.py <input_file>
```

- `<input_file>`: 変換したい入力ファイルのパスを指定します。

### 例
```bash
python convert2md.py example.jpg
```

このコマンドは、`example.jpg`をMarkdown形式に変換し、`example.md`というファイルを生成します。