#pip install python-magic-bin
#pip install python-magic

import sys
import zipfile
import magic


infile = ''
if len(sys.argv) >= 1: infile = sys.argv[1]


def judge_office_file_type_by_content(filepath):
    mime = magic.from_file(filepath, mime=True)

    if mime == 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
        return 'Word'
    elif mime == 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
        return 'Excel'
    elif mime == 'application/vnd.openxmlformats-officedocument.presentationml.presentation':
        return 'PowerPoint'
    else:
        return f'Unknown ({mime})'

def judge_office_file_type_by_zip(filepath):
    try:
        with zipfile.ZipFile(filepath, 'r') as zipf:
            namelist = zipf.namelist()
            if 'word/document.xml' in namelist:
                return 'Word'
            elif 'xl/workbook.xml' in namelist:
                return 'Excel'
            elif 'ppt/presentation.xml' in namelist:
                return 'PowerPoint'
            else:
                return 'Unknown (OpenXML ZIP)'
    except zipfile.BadZipFile:
        return 'Not a ZIP-based Office file'

try:
    print("judge by magic      : ", judge_office_file_type_by_content(infile))
except:
    pass
try:
    print("judge by zip content: ", judge_office_file_type_by_zip(infile))
except:
    pass
