import os
import sys
import base64


# 入力ファイル名
infile = '250901_Bi2S3.raw'

if len(sys.argv) > 1: infile = sys.argv[1]

outfile = os.path.splitext(infile)[0] + '.base64'

print()
print(f"{infile=}")
print(f"{outfile=}")


# バイナリ読み込み → Base64エンコード → 保存
with open(infile, 'rb') as f_in:
    binary_data = f_in.read()
    encoded_data = base64.b64encode(binary_data)

with open(outfile, 'wb') as f_out:
    f_out.write(encoded_data)

print(f"Base64エンコード済みファイルを保存しました: {outfile}")
