# whisper_split.py ドキュメント

## 1) プログラムの動作
`whisper_split.py`は、指定された音声ファイル（MP3形式）を分割し、各チャンクをOpenAIのWhisper APIを使用して文字起こしを行うプログラムです。音声ファイルは指定された長さのチャンクに分割され、各チャンクがAPIに送信されて文字起こしが行われます。最終的に、すべての文字起こし結果が1つのテキストファイルにまとめられます。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは以下の非標準ライブラリを使用しています。

- `python-dotenv`: 環境変数を管理するためのライブラリ
- `pydub`: 音声ファイルを操作するためのライブラリ
- `openai`: OpenAI APIを使用するためのライブラリ

### インストールコマンド
以下のコマンドを使用して必要なライブラリをインストールできます。

```bash
pip install python-dotenv pydub openai
```

## 3) 必要な入力ファイル
- **音声ファイル**: プログラム内で指定された音声ファイル（例: `e:\GMT20250227-035951_Recording_2560x1440.mp3`）が必要です。このファイルはMP3形式である必要があります。
- **環境設定ファイル**: `translate.env`と`accounts.env`という2つの環境設定ファイルが必要です。これらのファイルには、OpenAI APIキーやその他の設定が含まれています。

## 4) 実行後に生成される出力ファイル
- **出力ファイル**: プログラムの実行後、指定されたパス（デフォルトは`transcript.txt`）に文字起こし結果が保存されます。このファイルには、音声ファイルの内容がテキスト形式で記録されます。

## 5) コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから以下のように実行できます。

```bash
python whisper_split.py [input_file] [output_path] [guess_speakers] [chunk_length_minutes] [max_chunks]
```

### 引数の説明
- `input_file`: 文字起こし対象の音声ファイルのパス（例: `e:\GMT20250227-035951_Recording_2560x1440.mp3`）
- `output_path`: 文字起こし結果を保存するファイルのパス（例: `transcript.txt`）
- `guess_speakers`: 推測する話者の数（デフォルトは1）
- `chunk_length_minutes`: 音声を分割する長さ（分単位、デフォルトは5分）
- `max_chunks`: 処理する最大チャンク数（デフォルトは1000）

### 使用例
```bash
python whisper_split.py "e:\GMT20250227-035951_Recording_2560x1440.mp3" "transcript.txt" 2 5 1000
```

この例では、指定された音声ファイルを5分ごとに分割し、最大2人の話者を推測し、1000チャンクまで処理します。結果は`transcript.txt`に保存されます。