# translate_url.py ドキュメント

## 1) プログラムの動作
`translate_url.py` は、指定されたURLからHTMLコンテンツを取得し、その中の日本語テキストを英語に翻訳するプログラムです。DeepL APIを使用して翻訳を行い、翻訳後のHTMLを新しいファイルに保存します。プログラムはコマンドライン引数を受け取り、翻訳元の言語と翻訳先の言語を指定することができます。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは以下の非標準ライブラリを使用しています。

- `requests`: HTTPリクエストを送信するためのライブラリ
- `beautifulsoup4`: HTMLやXMLの解析を行うためのライブラリ
- `python-dotenv`: 環境変数を管理するためのライブラリ
- `chardet`: 文字エンコーディングを検出するためのライブラリ

### インストールコマンド
以下のコマンドを使用して必要なライブラリをインストールできます。

```bash
pip install requests beautifulsoup4 python-dotenv chardet
```

## 3) 必要な入力ファイル
プログラムは以下の2つの環境設定ファイルを必要とします。

1. `accounts.env`: DeepL APIキーとエンドポイントを含む設定ファイル
   - 必要な環境変数:
     - `DEEPL_API_KEY`: DeepL APIの認証キー
     - `endpoint`: DeepL APIのエンドポイントURL

2. `translate.env`: その他の設定を含むファイル
   - 必要な環境変数:
     - `force_server_charcode`: サーバーの文字コード（オプション）
     - `out_html`: 出力HTMLファイル名（オプション）

## 4) 実行後に生成される出力ファイル
プログラムの実行後、翻訳されたHTMLコンテンツが指定されたファイル名で保存されます。ファイル名は、元のURLから自動生成されるか、`out_html` 環境変数で指定された名前になります。ファイルはUTF-8エンコーディングで保存されます。

## 5) コマンドラインでの使用例 (Usage)
プログラムは以下の形式でコマンドラインから実行できます。

```bash
python translate_url.py <url> [<source_lang> <target_lang>]
```

### 引数の説明
- `<url>`: 翻訳したいHTMLコンテンツのURL
- `<source_lang>`: 翻訳元の言語コード（デフォルトは `JA`）
- `<target_lang>`: 翻訳先の言語コード（デフォルトは `EN`）

### 使用例
```bash
python translate_url.py http://example.com/page.html JA EN
```

このコマンドは、`http://example.com/page.html` の日本語コンテンツを英語に翻訳し、翻訳結果を新しいHTMLファイルに保存します。