# translate_pptx.py Documentation

## 1) プログラムの動作
`translate_pptx.py`は、指定されたPowerPointプレゼンテーションファイル（.pptx）内の日本語のテキストを英語に翻訳するプログラムです。DeepL APIを使用して翻訳を行い、翻訳されたテキストを新しい.pptxファイルとして保存します。プログラムは、スライド内のテキストフレームを検出し、各段落を翻訳します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています。

- `python-dotenv`: 環境変数を管理するためのライブラリ
- `python-pptx`: PowerPointファイルを操作するためのライブラリ
- `requests`: HTTPリクエストを送信するためのライブラリ

### インストールコマンド
以下のコマンドを使用して、必要なライブラリをインストールできます。

```bash
pip install python-dotenv python-pptx requests
```

## 3) 必要な入力ファイル
プログラムを実行するには、以下の入力ファイルが必要です。

- `translate_test.pptx`: 翻訳対象のPowerPointファイル
- `translate_url.env`: DeepL APIの認証キーを含む環境変数ファイル。以下の内容を含む必要があります。
  ```
  DEEPL_API_KEY=your_api_key_here
  endpoint=https://api.deepl.com/v2/translate
  ```

## 4) 実行後に生成される出力ファイル
プログラムの実行後、翻訳されたテキストを含む新しいPowerPointファイルが生成されます。出力ファイルの名前は、元のファイル名に`_translated`を付加したものになります。

例: `translate_test_translated.pptx`

## 5) コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから実行できます。以下のコマンドを使用して、翻訳を実行します。

```bash
python translate_pptx.py [input_file] [process_unit]
```

### 引数
- `input_file` (オプション): 翻訳するPowerPointファイルのパス。指定しない場合は、デフォルトで`translate_test.pptx`が使用されます。
- `process_unit` (オプション): 翻訳の単位を指定します。`paragraph`または`run`を指定できます。デフォルトは`paragraph`です。

### 使用例
```bash
python translate_pptx.py translate_test.pptx paragraph
```

このコマンドは、`translate_test.pptx`ファイルを翻訳し、段落単位で処理します。