# translate_pdf2.py Documentation

## 1) プログラムの動作
`translate_pdf2.py`は、PDFファイルからテキストを抽出し、そのテキストを翻訳してMarkdown形式で保存するプログラムです。具体的には、以下の手順で動作します：

1. 環境変数からAPIキーや設定を読み込む。
2. 指定されたPDFファイルを読み込み、テキストをMarkdown形式に変換。
3. OpenAI APIを使用して、抽出したテキストを校正。
4. DeepL APIを使用して、校正されたテキストを指定した言語に翻訳。
5. 各ステップで生成されたファイルを保存。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています：

- `python-dotenv`: 環境変数の管理
- `PyMuPDF`: PDFファイルの操作
- `requests`: HTTPリクエストの送信
- `openai`: OpenAI APIとのインターフェース
- `markitdown`: PDFからMarkdownへの変換

### インストールコマンド
以下のコマンドを使用して、必要なライブラリをインストールできます：

```bash
pip install python-dotenv PyMuPDF requests openai markitdown
```

## 3) 必要な入力ファイル
プログラムを実行するためには、以下の入力ファイルが必要です：

- `Snyder-charge transport-NatMater2017.pdf`: 翻訳対象のPDFファイル。
- `translate.env`: 環境変数を設定するためのファイル。
- `accounts.env`: APIキーなどのアカウント情報を設定するためのファイル。

これらのファイルは、プログラムが実行されるディレクトリに存在する必要があります。

## 4) 実行後に生成される出力ファイル
プログラムの実行後、以下の出力ファイルが生成されます：

- `output.md`: PDFから抽出したテキストをMarkdown形式で保存したファイル。
- `output_reformat.md`: 校正されたMarkdown形式のテキストを保存したファイル。
- `translated.md`: 翻訳されたテキストを保存したファイル。

## 5) コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから実行できます。以下は使用例です：

```bash
python translate_pdf2.py [input_pdf] [temperature] [max_tokens]
```

### 引数
- `input_pdf`: 翻訳対象のPDFファイル名（省略可能、デフォルトは`Snyder-charge transport-NatMater2017.pdf`）。
- `temperature`: OpenAI APIの温度パラメータ（省略可能、デフォルトは`0.3`）。
- `max_tokens`: OpenAI APIの最大トークン数（省略可能、デフォルトは`16384`）。

### 例
```bash
python translate_pdf2.py Snyder-charge transport-NatMater2017.pdf 0.5 15000
```

このコマンドは、指定されたPDFファイルを読み込み、OpenAI APIの温度を`0.5`、最大トークン数を`15000`に設定して実行します。