# translate_pdf.py Documentation

## 1) プログラムの動作
`translate_pdf.py`は、PDFファイルを指定された翻訳APIを使用して翻訳し、翻訳結果を新しいPDFファイルとして出力するプログラムです。具体的には、以下の手順で動作します。

1. 環境変数から設定を読み込み、APIキーや翻訳の設定を取得します。
2. 指定されたPDFファイルをDOCX形式に変換します。
3. DOCXファイルからテキストを抽出し、選択された翻訳API（DeepLまたはOpenAI）を使用して翻訳します。
4. 翻訳されたテキストを元のPDFに挿入し、新しいPDFファイルとして保存します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています。

- `python-dotenv`: 環境変数の読み込み
- `pdf2docx`: PDFをDOCXに変換
- `requests`: HTTPリクエストの送信
- `openai`: OpenAI APIとのインターフェース
- `PyMuPDF` (fitz): PDFファイルの操作

### インストールコマンド
以下のコマンドを使用して必要なライブラリをインストールできます。

```bash
pip install python-dotenv pdf2docx requests openai PyMuPDF
```

## 3) 必要な入力ファイル
プログラムを実行するには、以下の入力ファイルが必要です。

- `translate.env`: プログラムの設定を含む環境変数ファイル
- `accounts.env`: APIキーなどのアカウント情報を含む環境変数ファイル
- `Snyder-charge transport-NatMater2017.pdf`: 翻訳対象のPDFファイル（デフォルト名）

## 4) 実行後に生成される出力ファイル
プログラムの実行後、以下の出力ファイルが生成されます。

- `_translated.pdf`: 翻訳されたテキストを含む新しいPDFファイル
- `_translated.docx`: PDFから変換されたDOCXファイル（翻訳前のテキストを含む）

## 5) コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから以下のように実行できます。

```bash
python translate_pdf.py [API] [INPUT_PDF] [TEMPERATURE] [MAX_TOKENS]
```

### 引数の説明
- `API`: 使用する翻訳API（例: `deepl` または `openai`）
- `INPUT_PDF`: 翻訳対象のPDFファイル名（デフォルトは `Snyder-charge transport-NatMater2017.pdf`）
- `TEMPERATURE`: 翻訳の温度設定（デフォルトは `0.3`）
- `MAX_TOKENS`: 最大トークン数（デフォルトは `2000`）

### 例
```bash
python translate_pdf.py deepl Snyder-charge transport-NatMater2017.pdf 0.5 1500
```

このコマンドは、DeepL APIを使用して指定されたPDFファイルを翻訳し、翻訳結果を新しいPDFファイルとして保存します。