# translate_openai.py Documentation

## 1) プログラムの動作
`translate_openai.py`は、指定された入力ファイル（.docx、.pptx、または.md形式）を翻訳し、修正するPythonプログラムです。OpenAIのAPIを使用して、テキストを翻訳します。プログラムは、段落単位または文字列単位での処理を選択でき、マルチバイト文字を含む文字列のみを翻訳するオプションも提供しています。翻訳結果は新しいファイルとして保存されます。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
以下の非標準ライブラリが必要です：

- `python-dotenv`: 環境変数を管理するため
- `python-docx`: Word文書を操作するため
- `python-pptx`: PowerPointプレゼンテーションを操作するため
- `markitdown`: Markdown形式の変換を行うため
- `openai`: OpenAI APIを使用するため

### インストールコマンド
```bash
pip install python-dotenv python-docx python-pptx markitdown openai
```

## 3) 必要な入力ファイル
- `accounts.env`: OpenAI APIキーを含む環境変数ファイル
- `translate.env`: プログラムの設定に必要な環境変数ファイル（`role_content`と`prompt_template`を含む）
- 翻訳対象のファイル（.docx、.pptx、または.md形式）

## 4) 実行後に生成される出力ファイル
- 入力ファイル名に基づいて生成される出力ファイル。例えば、`translate_test.docx`が入力の場合、`translate_test_revised.docx`が出力されます。
- Markdown形式を使用する場合、`_revised.md`ファイルも生成されます。

## 5) コマンドラインでの使用例 (Usage)
```bash
python translate_openai.py infile process_unit use_markdown limit_to_multibyte_str
```

### 引数の説明
- `infile`: 翻訳対象の入力ファイル名（.docx、.pptx、または.md）
- `process_unit`: 'paragraph'（推奨）または 'run'（文字フォーマットを保持するため）
- `use_markdown`: 中間生成されたMarkdownファイルを翻訳するかどうか（1または0）
- `limit_to_multibyte_str`: マルチバイト文字を含む文字列のみを翻訳するかどうか（1または0）

### 使用例
```bash
python translate_openai.py translate_test.docx paragraph 0 1
```
このコマンドは、`translate_test.docx`を段落単位で翻訳し、マルチバイト文字を含む文字列のみを翻訳します。Markdown形式は使用しません。