# translate_file.py Documentation

## 1) プログラムの動作
このプログラムは、DeepL APIを使用して指定されたWord文書（.docxファイル）を翻訳します。プログラムは以下の手順で動作します：

1. コマンドライン引数から入力ファイル名と出力ファイル名を取得します。
2. 環境変数からDeepL APIキーを読み込みます。
3. 翻訳するファイルが以前に翻訳されたかどうかを確認します。もし翻訳済みであれば、その情報を使用します。
4. 翻訳が未実施の場合、ファイルをDeepL APIにPOSTリクエストとして送信し、翻訳を依頼します。
5. 翻訳の進行状況を確認し、完了したら翻訳結果をダウンロードします。
6. 翻訳結果を指定された出力ファイルに保存します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています：

- `python-dotenv`: 環境変数を管理するためのライブラリ
- `requests`: HTTPリクエストを送信するためのライブラリ
- `toml`: TOMLファイルを操作するためのライブラリ

### インストールコマンド
以下のコマンドを使用して必要なライブラリをインストールできます：

```bash
pip install python-dotenv requests toml
```

## 3) 必要な入力ファイル
プログラムを実行するには、以下の入力ファイルが必要です：

- `translate_test.docx`: 翻訳対象のWord文書（.docx形式）
- `translate_url.env`: DeepL APIキーを含む環境変数ファイル（例: `DEEPL_API_KEY=your_api_key`）
- `id_list.ini`: 翻訳済みファイルの情報を保存するためのTOML形式のファイル（初回実行時は自動生成されます）

## 4) 実行後に生成される出力ファイル
プログラムの実行後、翻訳された文書が以下の形式で出力されます：

- `translate_test_translated.docx`: 翻訳結果が保存されたWord文書（出力ファイル名は入力ファイル名に基づいて生成されます）

## 5) コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから以下のように実行します：

```bash
python translate_file.py [input_file] [output_file]
```

### 例
デフォルトの入力ファイルを使用し、出力ファイル名を指定する場合：

```bash
python translate_file.py translate_test.docx translated_output.docx
```

入力ファイルを指定し、出力ファイルはデフォルト名を使用する場合：

```bash
python translate_file.py translate_test.docx
```

この場合、出力ファイルは `translate_test_translated.docx` になります。