# translate_docx.py Documentation

## 1) プログラムの動作
`translate_docx.py`は、指定された.docxファイル内の日本語テキストを英語に翻訳するPythonプログラムです。DeepL APIを使用して翻訳を行い、翻訳結果を新しい.docxファイルに保存します。プログラムは、段落単位またはRun単位でテキストを処理することができ、テーブル内のテキストも翻訳対象とします。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています。

- `python-dotenv`: 環境変数を管理するためのライブラリ
- `python-docx`: .docxファイルを操作するためのライブラリ
- `requests`: HTTPリクエストを送信するためのライブラリ

### インストールコマンド
以下のコマンドを使用して必要なライブラリをインストールできます。

```bash
pip install python-dotenv python-docx requests
```

## 3) 必要な入力ファイル
プログラムを実行するには、以下の入力ファイルが必要です。

- `translate_test.docx`: 翻訳対象の.docxファイル
- `translate_url.env`: DeepL APIの認証キーを含む環境変数ファイル。以下の内容を含む必要があります。
  ```
  DEEPL_API_KEY=your_api_key_here
  endpoint=https://api.deepl.com/v2/translate
  ```

## 4) 実行後に生成される出力ファイル
プログラムの実行後、以下の出力ファイルが生成されます。

- `translate_test_translated.docx`: 翻訳されたテキストを含む新しい.docxファイル

## 5) コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから実行できます。以下は使用例です。

```bash
python translate_docx.py [input_file] [process_unit]
```

### 引数
- `input_file`: 翻訳する.docxファイルのパス（省略可能、デフォルトは`translate_test.docx`）。
- `process_unit`: 翻訳処理の単位（`paragraph`または`run`、省略可能、デフォルトは`paragraph`）。

### 例
1. デフォルトのファイルを翻訳する場合:
   ```bash
   python translate_docx.py
   ```

2. 指定したファイルを翻訳する場合:
   ```bash
   python translate_docx.py my_document.docx
   ```

3. Run単位で翻訳する場合:
   ```bash
   python translate_docx.py my_document.docx run
   ```