以下は translate5_GUI.py のコードを解析したドキュメントです。

1) プログラムの動作
- GUI (Tkinter) ベースの実行環境を提供します。起動時に設定を読み込み、入力ファイル・テンプレート・翻訳設定・プロンプトなどをGUI上で編集・保存できます。
- 主な機能
  - 入力ファイルの指定（.docx, .pptx, .pdf, .html/.htm, .md, .txt など）
  - HTML テンプレートの指定
  - モード選択（日本語→英語 je / 英語→日本語 ej）
  - 出力単位の選択（paragraph / run / md）
  - API の選択（openai / openai5 / google / deepl）
  - モデルの選択（APIに応じて候補が動的に切替）
  - エンドポイントの設定（DeepL やカスタムエンドポイント等）
  - Generation parameters（temperature、max_tokens/ max_output_tokens、reasoning_effort など）
  - 変換ルール・プロンプトのカスタム入力欄（Translate Role / Translate Prompt / Reformat Role / Reformat Prompt）
  - 実行ボタンで translate5.execute(cfg) をバックグラウンドスレッドで実行
  - 実行中はボタンを無効化、完了・エラー時はステータス表示
  - 詳細なエラーをカスタムダイアログに表示（コピー可能なダイアログを提供）
  - 設定は設定ファイル CONFIG_INI に保存・読み込み（ジオメトリ・入力ファイル・テンプレ・API設定等を保持）
  - ログ/状態の表示（ステータスバーに「Ready」「Running…」「Done」などを表示）
- バックグラウンド実行
  - 実行は別スレッドで行われ、UIの応答性を確保します。
  - 例外発生時には詳細な traceback を含むダイアログを表示します。

2) 必要な非標準ライブラリとインストールコマンドとインストール方法
- 非標準ライブラリ
  - ttkthemes（ThemedTk を提供。テーマ付き Tkinter ウィンドウを利用可能にする）
- 依存関係のインストール例
  - Python 環境を用意した上で以下を実行:
    - pip install ttkthemes
- 補足
  - translate5_GUI.py は translate5, tkai_lib などの内部モジュールをインポートしています。これらは同一プロジェクト内のモジュールであることを想定しています。もし外部から取得する必要がある場合は、それらも適切に配置・インストールしてください。
  - Tkinter は標準ライブラリですが、環境によっては別途インストールが必要な場合があります（例: Linux の場合は tkinter パッケージを別途インストール）。

3) 必要な入力ファイル
- 入力ファイル
  - Input file (.docx/.pptx/.pdf/.html/.htm/.md/.txt など) を GUI で指定します。翻訳元の本文がこのファイルから読み込まれる前提です。
- HTML テンプレート
  - template_translate.html（もしくは GUI で指定した任意の HTML テンプレート）
- 設定ファイル
  - CONFIG_INI（translate5_GUI.py と同じディレクトリ名の .ini ファイル。Settings セクションに GUI の状態を保存します）
- 環境変数
  - OPENAI_API_KEY、GOOGLE_API_KEY、DEEPL_API_KEY などの API キー（OpenAI/Google/DeepL 系を使用する場合に必要）

4) 実行後に生成される出力ファイル
- 出力ファイルの具体的なファイル名は translate5 の実装に依存します。GUI は cfg の設定を統合して translate5.execute(cfg) を呼ぶため、生成されるファイルは以下のような形式が想定されます。
  - HTML 出力（output_html_path が設定されている場合、そのパスへ出力される可能性）
  - 翻訳結果を含む新規ファイル（入力ファイルの翻訳版、または分割出力、章ごとなど、translate5 の実装次第）
  - 最終的なプロンプト・ロール・リファーマットの適用結果を元にした出力（書き出し形式は translate5 の実装に依存）
- GUI 側で明示されている設定項目
  - cfg.output_html_path を None に設定するように事前コードが動作しており、デフォルトでは出力先が特定のパスに固定されていない/未設定になる可能性があります。実際の出力先は translate5.execute(cfg) の内部実装次第です。
- 重要: ここでの出力は translate5.py 内の execute(cfg) に委譲されるため、出力ファイルの具体名・場所は translate5 の実装を参照してください。GUI は設定と入力を渡す役割を担います。

5) コマンドラインでの使用例 (Usage)
- GUI の起動
  - Windows/macOS/Linux 共通
    - python translate5_GUI.py
- 注意点
  - 事前に ttkthemes をインストールしておく必要があります（pip install ttkthemes）。
  - translate5_GUI.py は内部モジュールとして translate5.py および tkai_lib.py を利用します。これらが同じディレクトリに存在するか、適切な PYTHONPATH が設定されている必要があります。
  - API キー等の環境変数が必要な場合は、実行前に環境変数を設定しておく必要があります（例：export OPENAI_API_KEY=...）。
- 実行の流れ
  - GUI を起動して、入力ファイル・テンプレート・設定を入力・変更
  - 「Run execute()」ボタンを押すとバックグラウンドスレッドで translate5.execute(cfg) が呼ばれ、処理が開始される
  - 処理中はステータスバーに「Running execute() ...」が表示され、完了時に「Done.」、エラー時にはエラー詳細を含むダイアログが表示されます
  - 終了時には設定を CONFIG_INI に保存して GUI を閉じることができます

補足
- ThemedTk がインストールされていない環境では通常の Tkinter ウィンドウで動作します。ThemedTk が利用可能な場合、plastik テーマで表示されます。
- CopyableErrorDialog クラスにより、エラーログをコピー可能なウィンドウとして表示します。デバッグ時に detailliert な traceback を取得して表示します。
- 設定の読み込み・保存は _load_config / _save_config で実装されています。設定ファイルが存在しない場合はデフォルト値のまま起動します。

もし、特定の環境（例: Linux ディストリビューション名、Python バージ