# プログラムドキュメント: transcript_whisper.py

## 1) プログラムの動作
このプログラムは、音声ファイルを文字起こしし、その文字起こし結果を要約するためのPythonスクリプトです。具体的には、以下の手順で動作します：
1. 環境変数からAPIキーやモデルの設定を読み込みます。
2. 指定された音声ファイル（`generative_ai_programming.wav`）をWhisper APIを使用して文字起こしします。
3. 文字起こしされたテキストをChatGPT APIを使用して要約します。
4. 文字起こし結果と要約結果をコンソールに出力します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています：

- `python-dotenv`: 環境変数を管理するためのライブラリ
- `openai`: OpenAIのAPIを使用するためのライブラリ

### インストールコマンド
以下のコマンドを使用して、必要なライブラリをインストールできます：

```bash
pip install python-dotenv openai
```

## 3) 必要な入力ファイル
プログラムを実行するためには、以下の入力ファイルが必要です：

- `translate.env`: 環境変数を設定するためのファイル。APIキーやモデル名、温度、最大トークン数などの設定が含まれます。
- `accounts.env`: アカウント情報を含む環境変数ファイル（オプション）。`translate.env`で指定された場合に読み込まれます。
- `generative_ai_programming.wav`: 文字起こしを行う音声ファイル。

## 4) 実行後に生成される出力ファイル
このプログラムは、実行後にファイルを生成しませんが、コンソールに以下の情報を出力します：

- 文字起こし結果
- 要約結果

## 5) コマンドラインでの使用例 (Usage)
プログラムは直接実行することで使用します。以下のコマンドを使用して実行できます：

```bash
python transcript_whisper.py
```

実行すると、コンソールに文字起こし中と要約中のメッセージが表示され、最終的に文字起こし結果と要約結果が出力されます。