# プログラムドキュメント: transcript_google_speech.py

## 1) プログラムの動作
このプログラムは、指定されたローカルの音声ファイルをGoogle Cloud Speech-to-Text APIを使用して文字起こしし、その結果をGemini APIを使用して要約します。音声ファイルはWAV形式で、1分未満の短い音声に適しています。プログラムは以下の手順で動作します：
1. 環境変数からAPIキーを読み込みます。
2. 指定された音声ファイルを読み込み、Google Cloud Speech-to-Text APIに送信して文字起こしを行います。
3. 文字起こし結果をGemini APIに送信し、要約を生成します。
4. 文字起こし結果と要約結果をコンソールに出力します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
以下の非標準ライブラリが必要です。これらはpipを使用してインストールできます。

```bash
pip install google-cloud-speech pydub google-generativeai python-dotenv openai google-api-core
```

### インストール方法
1. 上記のコマンドをターミナルまたはコマンドプロンプトに入力して実行します。
2. `pydub`は音声ファイルの処理に`ffmpeg`または`libav`を必要とするため、これらのツールもインストールしておく必要があります。

## 3) 必要な入力ファイル
- **ローカル音声ファイル**: `generative_ai_programming.wav`という名前の音声ファイルが必要です。このファイルはプログラムが実行されるディレクトリに存在する必要があります。

## 4) 実行後に生成される出力ファイル
このプログラムはファイルを生成しませんが、コンソールに以下の情報を出力します：
- 文字起こし結果
- 要約結果

## 5) コマンドラインでの使用例 (Usage)
プログラムを実行するには、以下のコマンドを使用します。

```bash
python transcript_google_speech.py
```

### 注意事項
- プログラムを実行する前に、環境変数に必要なAPIキー（`GEMINI_API_KEY`など）を設定しておく必要があります。
- 音声ファイルが指定されたパスに存在することを確認してください。ファイルが見つからない場合、エラーメッセージが表示されます。