# transcribe_whisper.py Documentation

## 1. プログラムの動作
`transcribe_whisper.py`は、音声ファイルを文字起こしし、その結果を要約するプログラムです。以下の手順で動作します：

1. 環境変数を読み込み、OpenAI APIキーを取得します。
2. 音声ファイルを指定し、Whisper APIを使用してその音声を文字起こしします。
3. 文字起こし結果から話者を推測するオプションがあれば、GPTモデルを使用して話者を特定します。
4. 文字起こし結果と要約をファイルに保存します。

## 2. 必要な非標準ライブラリとインストールコマンド
このプログラムは以下の非標準ライブラリを使用しています：

- `dotenv`
- `openai`

これらのライブラリは以下のコマンドでインストールできます：

```bash
pip install python-dotenv openai
```

## 3. 必要な入力ファイル
プログラムは以下の環境変数ファイルを必要とします：

- `translate.env`: 環境変数を設定するためのファイル。
- `accounts.env`: OpenAI APIキーを含むファイル（`account_inf_path`で指定）。

また、音声ファイルとして以下のファイルが必要です：

- `generative_ai_programming.wav`: 文字起こし対象の音声ファイル。

これらのファイルはプログラムと同じディレクトリに配置する必要があります。

## 4. 実行後に生成される出力ファイル
プログラムの実行後、以下の出力ファイルが生成されます：

- `*_transcript.txt`: 文字起こし結果を含むファイル。
- `*_summary.txt`: 文字起こし結果の要約を含むファイル。
- `*_guessed.json`: 話者推測結果を含むJSONファイル（話者推測が有効な場合）。

出力ファイルは、元の音声ファイルと同じディレクトリに保存されます。

## 5. コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから以下のように実行できます：

```bash
python transcribe_whisper.py [audio_file_path] [guess_speakers]
```

- `audio_file_path`: 文字起こし対象の音声ファイルのパス（省略可能、デフォルトは`generative_ai_programming.wav`）。
- `guess_speakers`: 話者推測を行うかどうかのフラグ（省略可能、デフォルトは`1`で推測を行う）。

### 例
音声ファイルを指定して実行する場合：

```bash
python transcribe_whisper.py my_audio.wav 1
```

デフォルトの音声ファイルを使用する場合：

```bash
python transcribe_whisper.py
```

このプログラムを実行することで、音声ファイルの文字起こしと要約を簡単に行うことができます。