# Textbook Builder 使用説明書

このプログラムは **PowerPoint スライド (PPTX)** と **Zoom 録画 (音声/動画)** を基に、講義ごとの Markdown 教科書を自動生成します。  
出力された Markdown は Pandoc や Quarto で PDF / Word / ePub へ変換可能です。

---

## 動作概要

1. 各講義フォルダを探索し、`slides.pptx` を読み込む  
2. スライド内の **テキスト・ノート欄・埋め込み画像** を抽出  
3. 同じフォルダにある **音声/動画ファイル** を Whisper で文字起こし（オプション）  
4. 各講義フォルダに `lectureXX.md` を生成  
5. 全章を連結した `book.md` を作成

---

## 必要な非標準ライブラリ

- [python-pptx](https://python-pptx.readthedocs.io/) : スライド読み込み  
- [Pillow](https://pillow.readthedocs.io/) : 画像処理基盤  
- [pydub](https://github.com/jiaaro/pydub) : 音声処理補助  
- [openai-whisper](https://github.com/openai/whisper) : Whisper 本家実装（ローカル版）  
- [faster-whisper](https://github.com/guillaumekln/faster-whisper) : 高速版 Whisper （任意）  

※ 文字起こしには **ffmpeg** のインストールも必要です

---

## インストール方法

Python 3.10 以上を前提とします。

```bash
# 仮想環境の作成 (推奨)
python -m venv venv
source venv/bin/activate  # Windows: venv\Scripts\activate

# 依存ライブラリのインストール
pip install python-pptx Pillow pydub
pip install openai-whisper   # Whisper 本家
# 追加で高速化したい場合
pip install faster-whisper
```

Windows の場合は別途 [FFmpeg](https://ffmpeg.org/download.html) をインストールし、PATH を通してください。

---

## Usage

```bash
python make_textbook.py --input-root <講義フォルダの親ディレクトリ>                         --output-root <出力ディレクトリ>                         --lang ja                         --whisper-model small                         --asr whisper                         --device auto
```

### 主なオプション

- `--input-root` : 各講義フォルダを含むルート（例: `./lectures`）
- `--output-root`: 出力先ディレクトリ
- `--lang`       : 文字起こしの言語コード（例: `ja`, `en`）
- `--whisper-model`: 使用するモデルサイズ（例: `tiny`, `small`, `medium`, `large-v3`）
- `--asr`        : 音声認識バックエンド (`whisper` / `faster` / `auto` / `none`)
- `--device`     : `cpu` または `cuda`（GPU利用可能なら `cuda` 推奨）
- `--ja-initial-prompt`: 日本語の句読点補正用の初期プロンプトを与える

---

## 使用例

講義フォルダ構成例：

```
CMS/
  lecture01/
    slides.pptx
    recording.mp4
  lecture02/
    slides.pptx
    audio.m4a
```

実行例：

```bash
python make_textbook.py --input-root ./CMS                         --output-root ./CMS/out                         --lang ja                         --whisper-model small                         --asr whisper                         --device auto                         --ja-initial-prompt "句読点を正しく挿入してください。"
```

出力：

```
CMS/out/
  lecture01/
    slides_text.json
    images/
    lecture01.md
    transcript.txt
    transcript.srt
    transcript.vtt
  lecture02/
    ...
  book.md
```

---

## 備考

- スライド全体画像を使いたい場合は、PowerPoint/LibreOffice で PNG エクスポートして  
  `lectureXX/slides_png/slide_001.png` として配置してください。自動的に Markdown に埋め込まれます。
- 本プログラムは MIT ライセンスのサンプルコードです。
