# summarize.py Documentation

## 1) プログラムの動作
`summarize.py`は、指定されたテキストファイル（講義の文字起こし）を要約するプログラムです。OpenAIのAPIを使用して、与えられたテキストを要約し、結果を指定された出力ファイルに保存します。プログラムは、環境変数からAPIキーやモデルの設定を読み込み、コマンドライン引数から入力ファイルや出力ファイルのパスを取得します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています。

- `python-dotenv`: 環境変数を管理するためのライブラリ
- `openai`: OpenAIのAPIを利用するためのライブラリ

### インストールコマンド
```bash
pip install python-dotenv openai
```

### インストール方法
上記のコマンドをターミナルまたはコマンドプロンプトで実行してください。

## 3) 必要な入力ファイル
- `transcript.txt`: 要約したい講義の文字起こしが含まれるテキストファイル。このファイルはプログラムの実行時に指定する必要があります。

## 4) 実行後に生成される出力ファイル
- `*_output.txt`: 要約結果が保存されるテキストファイル。出力ファイル名は、入力ファイル名に`_output`を付加したものになります。出力ファイルのパスは、コマンドライン引数で指定することもできます。

## 5) コマンドラインでの使用例 (Usage)
以下のコマンドを使用してプログラムを実行します。

```bash
python summarize.py [input_path] [output_path] [max_bytes]
```

### 引数
- `input_path`: 要約したい文字起こしファイルのパス（デフォルトは`transcript.txt`）。
- `output_path`: 要約結果を保存するファイルのパス（デフォルトは`*_output.txt`）。
- `max_bytes`: 要約するテキストの最大バイト数（デフォルトは20000バイト）。

### 例
```bash
python summarize.py transcript.txt summary.txt 15000
```

この例では、`transcript.txt`を要約し、結果を`summary.txt`に保存します。要約するテキストの最大バイト数は15000バイトに設定されています。