# speak_it.py Documentation

## 1) プログラムの動作
`speak_it.py`は、クリップボードにコピーされたテキストを音声に変換するツールです。ユーザーはコマンドライン引数を使用して、使用するテキスト読み上げエンジン（TTSエンジン）、出力ファイルのパス、読み上げ速度、声質などを指定できます。サポートされているTTSエンジンには、`pyttsx3`、`openai`、`pyopenjtalk`があります。音声データは指定されたファイル形式で保存され、必要に応じて再生されます。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
以下の非標準ライブラリが必要です：

- `python-dotenv`
- `pyperclip`
- `pyttsx3`
- `scipy`

これらのライブラリは、次のコマンドを使用してインストールできます：

```bash
pip install python-dotenv pyperclip pyttsx3 scipy
```

## 3) 必要な入力ファイル
このプログラムは、特に入力ファイルを必要としませんが、音声合成に使用するために以下の環境変数が設定された`.env`ファイルが必要です：

- `OPENAI_API_KEY`: OpenAI APIのキー
- `account_inf_path`: アカウント情報のパス（デフォルトは`accounts.env`）

また、`pyopenjtalk`を使用する場合は、HTSボイスファイルが指定されたパスに存在する必要があります。

## 4) 実行後に生成される出力ファイル
プログラムの実行後、指定されたパスに音声ファイルが生成されます。デフォルトでは、`output.mp3`または指定されたファイル名で保存されます。音声ファイルの形式は、使用するTTSエンジンによって異なります。

## 5) コマンドラインでの使用例 (Usage)
以下は、コマンドラインでの使用例です：

```bash
python speak_it.py --engine pyttsx3 --outfile output.mp3 --speed 1.0 --speaker mei
```

### 引数の説明
- `--engine`または`-e`: 使用するTTSエンジン（`openai`, `pyttsx3`, `pyopenjtalk`）
- `--outfile`または`-o`: 出力ファイルのパス（デフォルトは`output.mp3`）
- `--language`: `pyttsx3`で使用する言語（デフォルトは`japanese`）
- `--voicetype`: `pyttsx3`で使用する音声の種類（デフォルトは`female`）
- `--speed`または`-s`: 読み上げ速度（デフォルトは`1.0`）
- `--speaker`または`-p`: `pyopenjtalk`で使用する声質選択用のスピーカー名
- `--list-speakers`: `pyopenjtalk`で使用可能なスピーカーの一覧を表示

このプログラムを実行すると、クリップボードの内容が音声に変換され、指定されたファイルに保存されます。