# pptx2pdf_with_speaker_note.py Documentation

## 1) プログラムの動作
このプログラムは、指定されたPowerPoint（PPTX）ファイルをPDF形式に変換し、スピーカーノートを含める機能を提供します。Windows環境でMicrosoft PowerPointがインストールされている必要があります。プログラムは、PowerPointアプリケーションを起動し、指定されたPPTXファイルを開いて、スピーカーノートを含むPDFとして保存します。変換が成功した場合は`True`を返し、失敗した場合は`False`を返します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは、以下の非標準ライブラリを使用しています。

- `comtypes`: COMオブジェクトを操作するためのライブラリ
- `python-pptx`: PowerPointファイルを操作するためのライブラリ（サンプルPPTXファイルを作成するために使用）

### インストールコマンド
```bash
pip install comtypes python-pptx
```

### インストール方法
上記のコマンドをコマンドラインで実行することで、必要なライブラリをインストールできます。

## 3) 必要な入力ファイル
プログラムは、スピーカーノートを含むPowerPointファイル（PPTX形式）を必要とします。デフォルトでは、`test_presentation.pptx`という名前のファイルを期待しています。このファイルは手動で作成するか、プログラム内のサンプル生成機能を使用して作成することができます。

## 4) 実行後に生成される出力ファイル
プログラムが正常に実行されると、指定されたPDFファイル（デフォルトでは`test_presentation_with_notes.pdf`）が生成されます。このPDFには、スライドとそのスピーカーノートが含まれます。

## 5) コマンドラインでの使用例 (Usage)
プログラムは、コマンドラインから直接実行することができます。以下は、コマンドラインでの使用例です。

```bash
python pptx2pdf_with_speaker_note.py
```

このコマンドを実行すると、プログラムが開始され、指定されたPPTXファイルがPDFに変換されます。ファイルが存在しない場合は、サンプルPPTXファイルが自動的に生成されます。