# pptx2md.py

単一の PowerPoint (`.pptx`) を **Markdown 1ファイル**へ変換するミニツールです。

## 使い方
```bash
pip install python-pptx Pillow
python pptx2md.py --pptx path/to/slides.pptx --out-dir ./out                   --slides-png-dir ./slides_png                   --json-out
```

### 主なオプション
- `--slides-png-dir` : 事前に書き出したスライドPNGを取り込みます（`slide_001.png` 等）
- `--no-embedded-images` : PPTX内の埋め込み画像の抽出をスキップ
- `--no-notes` : ノート欄を出力しない
- `--images-dirname` : 埋め込み画像の保存先サブフォルダ名（既定: `images`）
- `--json-out` : 抽出結果を `slides_text.json` として併せて保存

出力ファイルは `out/<pptx名>.md` です。



pip install python-pptx Pillow

# 基本
python pptx2md.py --pptx path/to/slides.pptx --out-dir ./out

# スライドPNGも一緒に埋め込みたい場合（事前にPowerPointやLibreOfficeでPNGを書き出し）
python pptx2md.py --pptx path/to/slides.pptx --out-dir ./out --slides-png-dir ./slides_png

# 画像やノート欄を省く例
python pptx2md.py --pptx path/to/slides.pptx --out-dir ./out --no-embedded-images --no-notes

# 抽出結果のJSONも保存（デバッグ用）
python pptx2md.py --pptx path/to/slides.pptx --out-dir ./out --json-out
