#pip install pydub

import sys
from pydub import AudioSegment
from pydub.silence import detect_nonsilent

# 入力ファイルと出力ファイルのパスを指定
infile = 'input_audio.wav'  # デフォルトの入力音声ファイル
outfile = 'output_audio.wav'
if len(sys.argv) >= 2: infile = sys.argv[1]
if len(sys.argv) >= 3: outfile = sys.argv[2]

# 音声ファイルを読み込む
audio = AudioSegment.from_file(infile, format="mp3")

# ノイズサンプルを取得 (例: 最初の5秒間)
noise_duration_ms = 5000  # ミリ秒単位で指定
noise_sample = audio[:noise_duration_ms]

# ノイズサンプルの音量レベルを計算
noise_level = noise_sample.dBFS

# 簡易的なノイズ除去: ノイズレベルより一定の閾値を超える部分を保持
threshold_db = 10  # ノイズレベルより10dB以上大きい部分を保持
nonsilent_ranges = detect_nonsilent(audio, min_silence_len=500, silence_thresh=noise_level + threshold_db)

# ノイズを除去した音声を結合
processed_audio = AudioSegment.empty()
for start, end in nonsilent_ranges:
    processed_audio += audio[start:end]

# 結果を保存
processed_audio.export(outfile, format="wav")

print(f"ノイズ除去後の音声を保存しました: {outfile}")
