#pip install noisereduce librosa soundfile
import sys
import noisereduce as nr
import librosa
import soundfile as sf


# 音声ファイルを読み込む
infile = 'input_audio.wav'  # 入力音声ファイル
outfile = 'output_audio.wav'
if len(sys.argv) >= 1: infile = sys.argv[1]
if len(sys.argv) >= 1: outfile = sys.argv[2]

audio_data, sample_rate = librosa.load(infile, sr=None)

# ノイズサンプルを取得（例えば、最初の数秒間をノイズとして使用）
noise_duration = 5  # 秒
noise_sample = audio_data[0:int(sample_rate * noise_duration)]

# ノイズリダクションの実行
reduced_noise_audio = nr.reduce_noise(y=audio_data, y_noise=noise_sample, sr=sample_rate)

# 結果を保存
sf.write(outfile, reduced_noise_audio, sample_rate)

print(f"ノイズ除去後の音声を保存しました: {outfile}")
