
# md2html_mathjax.py

LaTeX を含む Markdown を、**MathJax の CDN と CSS を `<head>` に埋め込んだ単一 HTML** に変換します。

## インストール
```bash
pip install markdown pymdown-extensions
```

## 使い方
```bash
python md2html_mathjax.py input.md -o output.html
```

### よく使うオプション
- `--title "My Notes"` : HTML の `<title>` を指定（既定は Markdown の H1 またはファイル名）
- `--lang ja` : `<html lang="ja">`（既定: `ja`）
- `--mathjax-url` : 既定は `https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-chtml.js`
- `--css-file style.css` : 内蔵CSSの代わりに外部CSSファイルを `<style>` でインライン埋め込み
- `--no-css` : CSS を入れない

## 数式記法
- インライン: `$ ... $` または `\( ... \)`
- ディスプレイ: `$$ ... $$` または `\[ ... \]`

> 内部では `pymdownx.arithmatex` を使い、MathJax は `processHtmlClass: "arithmatex"` を用いて **数学表現のみ**を処理します。

## 例
```bash
python md2html_mathjax.py notes.md -o notes.html   --title "Lecture Notes"   --lang ja   --css-file my.css
```
