## プログラム `make_textbook5.py` の解析

### 1. プログラムの動作

`make_textbook5.py` は、講義の文字起こしテキストと、オプションで既存のスライドMarkdownを入力として受け取り、OpenAIまたはGoogle GeminiのAIモデルを利用して、新しい「教科書用Markdown」と「スライド用Markdown」を生成するPythonスクリプトです。

**主な機能と処理フロー:**

1.  **引数解析と設定読み込み**:
    *   コマンドライン引数を解析し、入力ファイル、出力ファイル、使用するAIモデル、出力言語、専門分野、役割などを指定します。
    *   `ai.env` ファイルまたは環境変数からAIのAPIキー（`OPENAI_API_KEY`, `GOOGLE_API_KEY`）とデフォルトモデル名を読み込みます。
    *   `--inifile` オプションで指定されたINIファイル（デフォルトは `make_textbook5.ini`）を読み込み、AIへのプロンプトテンプレート（`PROMPT_TEMPLATE_JA`, `PROMPT_TEMPLATE_EN`）などを設定します。このINIファイルは、複数行の値や変数展開をサポートします。

2.  **入力ファイルの読み込み**:
    *   `--infile` で指定された文字起こしテキストファイルの内容を読み込みます。
    *   `--in_slide` で指定された既存のスライドMarkdownファイルの内容を読み込みます（これはオプションです）。

3.  **AIプロンプトの構築**:
    *   選択されたAI（OpenAIまたはGoogle Gemini）に応じて、AIに渡すメッセージリストを構築します。
        *   **OpenAI (`openai`, `openai5`)**: `system` メッセージで一般的な指示を与え、その後に `user` メッセージで文字起こしテキスト、スライドMarkdown、最終的な指示を渡す会話形式。
        *   **Google Gemini (`gemini`, `google`)**: 全ての指示と内容を1つの `user` メッセージにまとめて渡す形式。
    *   プロンプトテンプレートは、INIファイルから読み込まれたものに、コマンドライン引数で指定された「専門分野」「役割」「出力言語」を埋め込んで作成されます。

4.  **AI APIの呼び出し**:
    *   構築されたメッセージリストとAPIキー、モデル名を使用して、指定されたAIサービス（OpenAIまたはGoogle Gemini）のAPIを呼び出します。
    *   対応するAPIクライアントライブラリ（`google-generativeai`, `openai`）を使用してAPIリクエストを送信し、AIからの応答を受け取ります。

5.  **出力の解析とファイル生成**:
    *   AIからの応答は、`[TEXTBOOK_START]...[TEXTBOOK_END]` と `[SLIDES_START]...[SLIDES_END]` という特定の形式で返されることを想定しています。
    *   正規表現を用いて、応答テキストから教科書の内容とスライドの内容を抽出します。
    *   抽出された内容を、それぞれ `--textbook` (`[infile]_textbook.md`がデフォルト) および `--slide` (`[infile]_slide.md`がデフォルト) で指定されたMarkdownファイルに書き込みます。

6.  **ログ生成**:
    *   AIに送信されたメッセージは、デバッグや履歴確認のために、入力ファイル名に基づく `.log` ファイル（例: `lecture.log`）にJSON形式で保存されます。

7.  **エラーハンドリング**:
    *   必要なライブラリの未インストール、入力ファイルの欠落、APIキーの未設定、AIからの応答形式エラーなど、様々な状況でエラーメッセージを表示してプログラムを終了します。

### 2. 必要な非標準ライブラリとインストールコマンドとインストール方法

このプログラムは以下の非標準ライブラリに依存しています。

*   **`google-generativeai`**: Google Gemini APIと連携するために必要です。
*   **`openai`**: OpenAI APIと連携するために必要です。
*   **`python-dotenv`**: `tkai_lib.read_ai_config` が環境変数 (`.env` ファイルなど) を読み込むために内部的に使用される可能性があります。プログラムのエラーメッセージに明記されているため、インストールが推奨されます。

**インストールコマンド:**

```bash
pip install google-generativeai openai python-dotenv
```

**インストール方法:**

上記のコマンドをターミナルまたはコマンドプロンプトで実行してください。Pythonのパッケージ管理システムである`pip`が、指定されたライブラリとその依存関係を自動的にダウンロードしてインストールします。

### 3. 必要な入力ファイル

プログラムの実行には、以下のファイルが必要となる場合があります。

1.  **文字起こしテキストファイル (`--infile`, `-i`)**
    *   **必須**: AIが教科書やスライドを生成するための基となる、講義の文字起こし内容を記述したプレーンテキストファイルです。
    *   **例**: `lecture.txt`

2.  **INI設定ファイル (`--inifile`)**
    *   **必須**: プロンプトテンプレート (`PROMPT_TEMPLATE_JA`, `PROMPT_TEMPLATE_EN`) やその他の設定を記述したファイルです。
    *   デフォルトでは、スクリプトと同じディレクトリ、またはカレントディレクトリの `make_textbook5.ini` を探します。
    *   **例 (`make_textbook5.ini`):**
        ```ini
        PROMPT_TEMPLATE_JA = """
        あなたは{field}の{role}です。
        以下の講義テキストとスライドのMarkdownを基に、教科書用Markdownとスライド用Markdownを作成してください。
        出力は{language}でお願いします。

        ---
        生成要件:
        1. 教科書用Markdownは、講義テキストの内容をより詳細に、体系的に解説してください。スライド内容も適切に統合してください。
        2. スライド用Markdownは、主要なポイントを簡潔にまとめ、箇条書きや図表のプレースホルダーを効果的に使用してください。
        3. 数式やコードブロックが必要な場合は、Markdownの適切な記法（例: `$$LaTeX$$`, `` `python` ``）を使用してください。
        4. 目次や見出しの階層構造を適切に設定してください。
        5. 出力は必ず以下の形式に従ってください。
        """

        PROMPT_TEMPLATE_EN = """
        You are a {field} {role}.
        Based on the following lecture transcript and slide Markdown, create textbook-style Markdown and slide-style Markdown.
        The output should be in {language}.

        ---
        Generation Requirements:
        1. The textbook Markdown should explain the lecture content more thoroughly and systematically. Integrate slide content appropriately.
        2. The slide Markdown should summarize key points concisely, using bullet points and placeholders for diagrams/tables effectively.
        3. If mathematical formulas or code blocks are necessary, use appropriate Markdown syntax (e.g., `$$LaTeX$$`, `` `python` ``).
        4. Set up the table of contents and heading hierarchy properly.
        5. The output must strictly follow the format below.
        """
        ```

3.  **入力スライドMarkdownファイル (`--in_slide`, `-im`)**
    *   **オプション**: AIが生成するスライドや教科書の参考にされる既存の講義スライドの内容を記述したMarkdownファイルです。
    *   **例**: `slide.md`

4.  **環境設定ファイル (`ai.env`)**
    *   **オプション**: AIサービスのAPIキーやデフォルトモデル名を環境変数として設定するためのファイルです。
    *   プログラムは `tkai_lib.read_ai_config` を介してこのファイルを読み込みます。
    *   **例 (`ai.env`):**
        ```
        OPENAI_API_KEY=sk-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        GOOGLE_API_KEY=AIzaSyBxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        OPENAI_MODEL=gpt-4o
        GOOGLE_MODEL=gemini-1.5-pro
        ```
    *   APIキーは、コマンドライン引数または環境変数で直接設定することも可能です。

### 4. 実行後に生成される出力ファイル

プログラムが正常に実行されると、以下のファイルが生成されます。

1.  **教科書Markdownファイル**
    *   **デフォルト名**: `--infile` で指定された入力ファイルのファイル名（拡張子を除く）に `_textbook.md` を付加したもの。
        *   例: 入力が `lecture.txt` なら `lecture_textbook.md`
    *   `-t` または `--textbook` オプションで指定されたファイル名を使用することもできます。
    *   **内容**: AIによって生成された、詳細で体系的な教科書形式のMarkdownテキスト。

2.  **スライドMarkdownファイル**
    *   **デフォルト名**: `--infile` で指定された入力ファイルのファイル名（拡張子を除く）に `_slide.md` を付加したもの。
        *   例: 入力が `lecture.txt` なら `lecture_slide.md`
    *   `-s` または `--slide` オプションで指定されたファイル名を使用することもできます。
    *   **内容**: AIによって生成された、主要なポイントを簡潔にまとめたスライド形式のMarkdownテキスト。

3.  **ログファイル**
    *   **デフォルト名**: `--infile` で指定された入力ファイルのファイル名（拡張子を除く）に `.log` を付加したもの。
        *   例: 入力が `lecture.txt` なら `lecture.log`
    *   **内容**: AIに送信されたプロンプトメッセージがJSON形式で保存されます。デバッグやAIへのリクエスト内容の確認に有用です。

### 5. コマンドラインでの使用例 (Usage)

基本的なコマンドライン引数:

```
usage: make_textbook5.py [-h] [--inifile INIFILE] [-i INFILE] [-im IN_SLIDE] [-t TEXTBOOK] [-s SLIDE] [-a {gemini,openai5,openai,google}] [--model MODEL] [--openai_model OPENAI_MODEL] [--openai_model5 OPENAI_MODEL5] [--google_model GOOGLE_MODEL] [--lang {ja,en}] [--field FIELD] [--role ROLE] [--pause]

講義の文字起こしとスライドをAIで教科書/スライドMarkdownに変換（Pandoc不要）。

options:
  -h, --help            show this help message and exit
  --inifile INIFILE     プロンプトなどを保存したkey=valファイル
  -i INFILE, --infile INFILE
                        文字起こしテキストファイル (例: lecture.txt)
  -im IN_SLIDE, --in_slide IN_SLIDE
                        入力 講義スライドMarkdown (任意, 例: slide.md)
  -t TEXTBOOK, --textbook TEXTBOOK
                        出力 教科書Markdown (デフォルト: [infile]_textbook.md)
  -s SLIDE, --slide SLIDE
                        出力 スライドMarkdown (デフォルト: [infile]_slide.md)

AI設定:
  -a {gemini,openai5,openai,google}, --api {gemini,openai5,openai,google}
                        使用API
  --model MODEL         明示モデル名の指定（apiごとに適用先を切替）
  --openai_model OPENAI_MODEL
  --openai_model5 OPENAI_MODEL5
  --google_model GOOGLE_MODEL
  --lang {ja,en}        出力言語 (デフォルト ja)
  --field FIELD         専門分野
  --role ROLE           役割
  --pause               終了前に入力待ち
```

**使用例:**

1.  **文字起こしテキストから教科書とスライドを生成する（デフォルト設定、Gemini APIを使用）**:
    ```bash
    python make_textbook5.py -i lecture.txt
    ```
    *   `lecture.txt` を入力として、`lecture_textbook.md` と `lecture_slide.md` を生成します。
    *   INIファイル `make_textbook5.ini` と `.env` ファイル `ai.env` がカレントディレクトリまたはスクリプトディレクトリにあると仮定します。

2.  **既存のスライドMarkdownも考慮に入れて生成する**:
    ```bash
    python make_textbook5.py -i lecture.txt -im existing_slide.md
    ```

3.  **出力ファイル名を指定し、OpenAI API (`gpt-4o`) を使用して生成する**:
    ```bash
    python make_textbook5.py -i lecture.txt -t my_course_textbook.md -s my_course_slides.md -a openai --openai_model gpt-4o
    ```

4.  **Google Gemini API (`gemini-1.5-flash`) を使用し、英語で出力し、専門分野と役割を指定する**:
    ```bash
    python make_textbook5.py -i transcript.txt --lang en -a gemini --google_model gemini-1.5-flash --field "Artificial Intelligence" --role "Data Scientist"
    ```

5.  **カスタムINIファイルを使用してプロンプト設定を変更する**:
    ```bash
    python make_textbook5.py -i lecture.txt --inifile my_custom_prompts.ini
    ```

6.  **AIからの応答を確認後、Enterキーで終了を待機する**:
    ```bash
    python make_textbook5.py -i lecture.txt --pause
    ```