# guess_speaker.py Documentation

## 1) プログラムの動作
`guess_speaker.py`は、与えられた講義の会話テキストから誤字・誤訳を訂正し、文ごとに改行を入れ、話者を推測するプログラムです。プログラムはOpenAIのAPIを使用して、テキストを解析し、話者の名前と発言をJSON形式で返します。最終的に、推測された話者とその発言を指定された出力ファイルに保存します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法
このプログラムは以下の非標準ライブラリを使用しています。

- `python-dotenv`: 環境変数を管理するためのライブラリ
- `openai`: OpenAIのAPIを使用するためのライブラリ

### インストールコマンド
```bash
pip install python-dotenv openai
```

### インストール方法
1. 上記のコマンドをターミナルまたはコマンドプロンプトで実行します。
2. 必要なライブラリがインストールされるのを待ちます。

## 3) 必要な入力ファイル
- `transcript.txt`: 講義の会話テキストが含まれるファイル。このファイルはプログラムの実行時に指定する必要があります。

## 4) 実行後に生成される出力ファイル
- `*_with_speakers.txt`: 推測された話者とその発言が含まれるテキストファイル。出力ファイル名は入力ファイル名に`_with_speakers`を付加したものになります。

## 5) コマンドラインでの使用例 (Usage)
以下のコマンドを使用してプログラムを実行します。

```bash
python guess_speaker.py [input_file] [output_file] [max_bytes]
```

### 引数
- `input_file`: 入力ファイルのパス（例: `transcript.txt`）
- `output_file`: 出力ファイルのパス（省略可能。指定しない場合は自動生成されます）
- `max_bytes`: 読み込む最大バイト数（省略可能。デフォルトは20000バイト）

### 使用例
```bash
python guess_speaker.py transcript.txt output.txt 15000
```

このコマンドは、`transcript.txt`を読み込み、15000バイトまでのテキストを処理し、結果を`output.txt`に保存します。