以下は、Python プログラム get_paper_inf5.py の解析と、仕様をまとめたドキュメントです。

# 1) プログラムの動作概要

- 指定された PDF ファイルからテキストを抽出し、そのテキストをもとに論文メタデータを抽出します。
- 抽出には、OpenAI（openai または openai5）または Google API を利用します（コマンドライン引数で選択）。
- 抽出されたメタデータを JSON 形式で取得し、指定のテキストファイルにあるフィールドを含む形で Excel 形式（XLSX）ファイルへ追記します。
- 抽出結果には、著者情報、論文タイトル、発行年、 doi などが含まれ、空欄は空文字列 "" で表現されます。
- オプションとして、AI が推奨するファイル名へリネームする機能があります。リネーム後は元ファイルの削除有無を選択できます。
- 複数の PDF に対して再帰探索（サブディレクトリ含む）や、出力先テンプレート、最大バイト制限、処理 API の切替などを設定可能です。

主な処理の流れ
- ai.env から設定を読み込み、環境変数で API 設定値を取得。
- PDF からテキストを抽出（最大バイト数 max_bytes で制限）。
- 抽出したテキストを、指定の API でメタデータを推定（OpenAI/Google いずれかを選択）。
- 推定結果を JSON から平坦化してまとめ、summary.xlsx に追記。
- 必要に応じて、推定された filename_rename で元ファイルをリネーム（delete_original で元ファイル削除の可否を指定）。

# 2) 必要な非標準ライブラリとインストール方法

このスクリプトは以下の非標準ライブラリを利用します。いずれも Python のパッケージとして入手可能です。

- openpyxl
  - 役割: Excel (XLSX) の読み書き
  - インストール: pip install openpyxl
- PyPDF2
  - 役割: PDF からのテキスト抽出
  - インストール: pip install pypdf2
- tkai_lib
  - 役割: OpenAI/Google API 呼び出しロジック、設定読み込み等の共通ライブラリ
  - インストール: tkai_lib は公開パッケージではない可能性が高く、リポジトリから入手する必要があります。通常は pip で公開されていない場合があるため、提供元のリポジトリ/フォルダを入手して Python パスに追加してください（例: git clone など）。
- (必要に応じて) PyCryptodome
  - 役割: テキスト抽出などの暗号関連でエラー回避の案内あり
  - インストール案内: pip install pycryptodome

参考: スクリプト内の import ブロックでは、openpyxl と PyPDF2 の import に失敗した場合にメッセージを表示して、インストールコマンドを案内する簡易的な対話を挿入します。

環境準備の注意
- 環境変数
  - OPENAI_API_KEY: OpenAI API キー
  - openai_model: OpenAI モデル名（デフォルト: gpt-4o、openai5 の場合は別モデル名）
  - temperature: OpenAI の温度パラメータ
  - max_tokens: OpenAI の最大出力トークン数
  - openai_model5: OpenAI 5 系モデル名（デフォルト: gpt-5-nano）
  - reasoning_effort: openai5 の推論努力レベル（例: low）
  - GOOGLE_API_KEY: Google API キー
  - gemini_model: Google/Gemini 系モデル名（デフォルトは gemini-2.5-flash）
- ai.env ファイルを用いた設定読み込みを想定

# 3) 必要な入力ファイル

- PDF ファイル
  - パスはコマンドラインの input_file 引数で指定します。
  - 最大 max_bytes バイト分だけテキストを API に送るように切り詰められます（extraction 後の slice: extracted_text[:max_bytes]）。
- ai.env
  - 設定を読み込むために ai.env ファイルが必要です（read_ai_config がこのファイルを参照します）。具体的なキーは openai_api_key など。
- その他
  - summary.xlsx へ出力を追記するため、初回は新規作成される場合があります。以降は既存ファイルへ追記します。

# 4) 実行後に生成される出力ファイル

- summary.xlsx
  - 出力ファイル。xlsx_labels に定義された列見出しに対応するデータを、各 PDF ごとに行として追加します。
  - 行には以下のフィールドが順次格納されます（データは metadata から取得、欠搏時は空文字列）。
    - directory, filename_original, filename_rename, authors, author_first, author_last, title, short_title, journal, short_name, shortest_name, date_received, date_accepted, date_published_online, date_published, year, volume, issue, pages, doi
- リネーム後のファイル
  - --rename が有効で、metadata に filename_rename が含まれている場合、input_file が新しい名前にリネームされます（新ファイル名に .pdf を付加する処理あり）。
- 非必須/副次的出力
  - リネーム処理が行われると、元ファイルが delete_original 指定に従って削除されることがあります。

# 5) コマンドラインでの使用例 (Usage)

以下は基本的な使用例です。環境依存の API キーやファイルパスは適宜書き換えてください。

- 単一ファイルに対する抽出と出力
  - python get_paper_inf5.py --api openai5 --summary_path summary.xlsx /path/to/your paper.pdf
    - openai5 を用いてメタデータを抽出し、summary.xlsx に追記します。
    - max_bytes のデフォルト値は 10000 バイトです。
    - デフォルトでリネームは無効化（--rename はデフォルト 0）なのでファイル名は変更されません。

- ディレクトリ配下を再帰探索して処理
  - python get_paper_inf5.py --api google --summary_path summary.xlsx /path/to/pdfs/**/*.pdf --recursive 1
    - サブディレクトリも再帰的に検索して処理します。
    - Google API を使用してメタデータを抽出します。

- 処理後にファイル名を推奨名へリネーム（推奨名が得られた場合のみ）
  - python get_paper_inf5.py --api openai5 --summary_path summary.xlsx --rename 1 /path/to/pdfs/paper.pdf
    - metadata に filename_rename が含まれている場合、同名の .pdf ファイルへリネームします。
    - delete_original を 1（デフォルト）にして実行すると、元ファイルを削除します。別オプションで削除を抑制可能です。

- 最大バイト数の指定
  - python get_paper_inf5.py --api openai --summary_path summary.xlsx --max_bytes 5000 /path/to/pdfs/short_paper.pdf
    - 論文全体を送る必要がない場合に、max_bytes を小さくして処理します。

- Summary 出力ファイル名のカスタマイズ
  - python get_paper_inf5.py --api openai5 --summary_path ./out/summary_long.xlsx /path/to/pdfs/paper.pdf
    - output の場所を任意のパスへ変更可能です。

補足
- --