# プログラムドキュメント: `gemini_grounding.py`

## 1) プログラムの動作
このプログラムは、GoogleのGeminiモデルを使用して、指定されたプロンプトに基づいてテキストを生成します。特に、Google検索を利用して最新の情報を取得し、生成されたテキストにグラウンディング（出典情報）を追加します。プログラムは、ユーザーが入力したプロンプトに対して、関連する情報を検索し、その結果を基にテキストを生成します。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは以下の非標準ライブラリを使用しています。

- `python-dotenv`: 環境変数を管理するためのライブラリ
- `google-generativeai`: Googleの生成AIモデルを使用するためのライブラリ

### インストール方法
以下のコマンドを使用して、必要なライブラリをインストールできます。

```bash
pip install python-dotenv google-generativeai
```

## 3) 必要な入力ファイル
プログラムを実行するためには、以下の環境変数を含むファイルが必要です。

- `accounts.env`: Google APIキーを含むファイル。ファイル内には以下のように記述されている必要があります。
  ```
  GOOGLE_API_KEY=your_api_key_here
  ```

## 4) 実行後に生成される出力ファイル
このプログラムは、出力ファイルを生成しませんが、コンソールに生成されたテキストとGoogle検索の結果を表示します。具体的には、以下の情報が表示されます。

- プロンプト
- 生成されたテキスト
- Google検索の結果（タイトル、URL、概要）

## 5) コマンドラインでの使用例 (Usage)
プログラムは直接実行することができます。以下はコマンドラインでの使用例です。

```bash
python gemini_grounding.py
```

実行すると、プログラムはデフォルトのプロンプト（例: "Google検索を使って、2025年のトランプ大統領の政策について要約してください"）を使用してテキストを生成し、結果をコンソールに表示します。プロンプトを変更したい場合は、`user_prompt`変数の値を変更してください。