import os
import sys
from pathlib import Path
import chardet
import re
from dotenv import load_dotenv
import google.generativeai as genai


#mode = 'list'
mode = 'search'
gemini_model = "gemini-1.5-pro-latest"  #gemini-1.0-pro-latest-vision

account_inf_path = "d:/MyWebs/Database/accounts.env"
load_dotenv(dotenv_path = account_inf_path)
GEMINI_API_KEY = os.getenv("GEMINI_API_KEY", None)


argv = sys.argv
nargs = len(argv)
if nargs > 1:
    mode = argv[1]

def main():
    genai.configure(api_key = GEMINI_API_KEY)

    if mode == 'list':
        models = genai.list_models()
        for model in models:
            print(f"Model: {model.name}")
            print(f"  Supported methods: {model.supported_generation_methods}")
    elif mode == "search":
        model = genai.GenerativeModel(gemini_model)

# 会話履歴（roleを指定）
        messages = [
            {
                'role': 'user',
                'parts': ["あなたは若い科学者として振る舞ってください。"]
            },
            {
                'role': 'model',
                'parts': ["承知いたしました。何かお手伝いできることはありますか？"]
            },
            {
                'role': 'user',
                'parts': ["以下の文を英訳してください #現在、環境保護の観点から、太陽エネルギーなどの再生エネルギーの開発が進んでいます"]
            }
        ]

        response = model.generate_content(messages)
        print()
        print("Prompt:", messages)
        print("Response:\n", response.text)


if __name__ == "__main__":
    main()
