# プログラムドキュメント: `gemini.py`

## 1) プログラムの動作
`gemini.py`は、GoogleのGenerative AIを使用して、指定されたモデルに基づいてユーザーからの入力に対する応答を生成するプログラムです。プログラムは、環境変数からAPIキーを読み込み、指定されたモード（`list`または`search`）に応じて動作します。

- **listモード**: 利用可能なモデルのリストを取得し、それぞれのモデルの名前とサポートされている生成メソッドを表示します。
- **searchモード**: 指定されたモデルを使用して、ユーザーからのメッセージに基づいて応答を生成します。デフォルトのメッセージは、科学者として振る舞うことを求める内容と、特定の文の英訳を依頼する内容です。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは以下の非標準ライブラリを使用しています。

- `python-dotenv`: 環境変数を管理するためのライブラリ
- `google-generativeai`: GoogleのGenerative AIを使用するためのライブラリ
- `chardet`: 文字エンコーディングを検出するためのライブラリ（使用されていないがインポートされています）
- `re`: 正規表現を扱うためのライブラリ（使用されていないがインポートされています）

### インストールコマンド
以下のコマンドを使用して、必要なライブラリをインストールできます。

```bash
pip install python-dotenv google-generativeai chardet
```

## 3) 必要な入力ファイル
プログラムは、環境変数を設定するために以下のファイルを必要とします。

- `accounts.env`: APIキーを含む環境変数ファイル。このファイルには、`GEMINI_API_KEY`というキーが含まれている必要があります。

## 4) 実行後に生成される出力ファイル
このプログラムは、出力をファイルに書き込むことはありませんが、コンソールに以下の情報を表示します。

- モデルのリスト（`list`モードの場合）
- ユーザーからのメッセージと生成された応答（`search`モードの場合）

## 5) コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから実行され、モードを指定することができます。以下は使用例です。

### モデルのリストを表示する
```bash
python gemini.py list
```

### 指定されたモデルで応答を生成する
```bash
python gemini.py search
```

このコマンドを実行すると、デフォルトのメッセージに基づいて応答が生成され、コンソールに表示されます。