`explain_program5.py` は、指定されたプログラムコードを解析し、OpenAIまたはGoogleのAIモデルを使用してそのドキュメント（動作、ライブラリ、入出力ファイル、使用例など）をMarkdown形式で自動生成するツールです。

---

### 1) プログラムの動作

このPythonスクリプトは、ユーザーが指定したプログラムコードファイル（Python、Perl、C、C++、Java、Go、各種シェルスクリプトなど）を読み込み、その内容をAI（OpenAIのGPTシリーズまたはGoogle Gemini）に送信して解析させ、結果をMarkdown形式のドキュメントとして出力します。

**主な機能:**

*   **AIモデルの選択**: OpenAI (GPT-4o, GPT-5-nano) または Google Gemini のAPIを切り替えて使用できます。
*   **コード解析とドキュメント生成**:
    *   指定されたファイルパターンに合致する一つまたは複数のコードファイルを読み込みます。
    *   ファイルの拡張子や命名規則に基づいて、そのプログラムが「メインスクリプト」なのか「ライブラリ」なのかを自動的に判断（またはユーザーが `--program_type` で明示的に指定）します。
    *   プログラムのタイプに応じて適切なプロンプトテンプレートを適用し、コードの内容と共にAIに送信します。
    *   AIからの応答（解析結果）をMarkdown形式で取得します。
*   **出力ファイル管理**:
    *   デフォルトでは、入力ファイルの拡張子を `.md` に変更したファイル名でドキュメントを生成します。
    *   `-o`/`--output` オプションで出力ファイル名を明示的に指定することも可能ですが、その場合は入力ファイルは一つでなければなりません。
    *   既存の出力ファイルがある場合、`-u`/`--update` オプションで入力ファイルより新しい場合はスキップし、`-w`/`--overwrite` オプションで無条件に上書きするなどの挙動を制御できます。
*   **設定管理**: `ai.env` ファイルからAPIキー、使用するAIモデル、温度（OpenAI用）、推論強度（OpenAI5用）などの設定を読み込みます。
*   **多様な言語サポート**: Python、Perl、C/C++、Pascal、Fortran、JavaScript、Java、Go、様々なシェルスクリプト、HTML/CSS/XMLなど、多くの言語のソースコードに対応しています。

**処理の流れ:**

1.  スクリプト起動時に、`ai.env` ファイルからAPIキーやデフォルトモデルなどのグローバル設定を読み込みます。
2.  コマンドライン引数を解析し、処理対象のファイルパターン、使用するAI API、出力オプションなどを取得します。
3.  指定されたファイルパターンにマッチする全てのファイルを列挙します。
4.  各入力ファイルについて、以下の処理を行います。
    *   対応する出力Markdownファイルのパスを決定します。
    *   `--update` または `--overwrite` オプションの状態と、ファイルのタイムスタンプに基づいて、ドキュメントの生成が必要かどうかを判断します。
    *   入力ファイルを読み込みます（UTF-8またはShift-JISエンコーディングを試行）。
    *   ファイルの拡張子や命名規則からプログラムタイプ（`main`または`lib`）を決定します。
    *   決定されたプログラムタイプと読み込んだコードに基づき、AIに送信するプロンプトを生成します。
    *   選択されたAI API (`openai`, `openai5`, `google`/`gemini`) を呼び出し、プロンプトを送信して解析結果を取得します。
    *   取得した解析結果をMarkdownファイルとして保存します。
    *   APIのレート制限を考慮し、次のファイル処理の前に1秒間待機します。
5.  全てのファイルの処理が完了したら、「Done.」と表示し、ユーザーがEnterキーを押すまでプログラムを終了せずに待機します。

### 2) 必要な非標準ライブラリとインストールコマンドとインストール方法

このプログラムは、AIサービスへの接続を抽象化するために、同じプロジェクト内で提供されているカスタムライブラリ `tkai_lib` を使用しています。`tkai_lib` 自体はpipでインストールするものではなく、`explain_program5.py` と同じディレクトリか、Pythonの検索パスが通った場所に配置されることを想定しています。

`tkai_lib` は内部でOpenAIおよびGoogle Geminiの公式APIクライアントライブラリに依存しているため、以下のライブラリをインストールする必要があります。

1.  **`openai`**: OpenAI API (GPT-4o, GPT-5-nano) にアクセスするために必要です。
    *   **インストールコマンド**:
        ```bash
        pip install openai
        ```
    *   **インストール方法**: 上記コマンドをターミナルまたはコマンドプロンプトで実行します。

2.  **`google-generativeai`**: Google Gemini API にアクセスするために必要です。
    *   **インストールコマンド**:
        ```bash
        pip install -U google-generativeai
        ```
    *   **インストール方法**: 上記コマンドをターミナルまたはコマンドプロンプトで実行します。

**補足:** `tkai_lib` が存在しない場合、`ImportError` が発生します。このプログラムを実行するには、`tkai_lib` ディレクトリまたは `tkai_lib.py` ファイルが、`explain_program5.py` と同じディレクトリにあるか、Pythonのモジュール検索パス (`PYTHONPATH`) に含まれている必要があります。

### 3) 必要な入力ファイル

このプログラムの実行には、主に以下のファイルが必要です。

1.  **`ai.env` (環境設定ファイル)**:
    *   AIサービスへのアクセスに必要なAPIキーや、使用するAIモデル、その他の設定（`max_tokens`, `temperature`, `reasoning_effort` など）が記述されたファイルです。
    *   プログラムは起動時にこのファイルを読み込みます。
    *   例:
        ```
        OPENAI_API_KEY=sk-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        GOOGLE_API_KEY=AIzaSxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        openai_model=gpt-4o
        openai_model5=gpt-5-nano
        gemini_model=gemini-1.5-flash
        max_tokens=3000
        temperature=0.3
        reasoning_effort=low
        ```
    *   **注意**: このファイルはプログラムと同じディレクトリに配置するか、パスが通っている必要があります。また、APIキーは非常に機密性の高い情報であるため、厳重に管理し、バージョン管理システムには含めないように注意してください。

2.  **処理対象のコードファイル**:
    *   コマンドライン引数の `pattern` で指定されるワイルドカードパターン（例: `*.py`, `my_script.py`, `src/*.c`）に一致するファイル群です。
    *   これらは解析対象となる実際のプログラムコードファイルです。Python、Perl、C、C++、Java、Go、シェルスクリプトなど、様々なプログラミング言語のソースコードが対象となります。

### 4) 実行後に生成される出力ファイル

プログラム実行後には、AIが生成したドキュメントがMarkdown形式で出力されます。

1.  **Markdownファイル (`.md` 拡張子)**:
    *   **ファイル名**:
        *   `output` 引数が指定されていない場合: 各入力ファイルのファイル名から元の拡張子を `.md` に置き換えたものになります（例: `my_script.py` → `my_script.md`）。
        *   `output` 引数が指定されている場合: その指定されたファイル名が使用されます（この場合、入力ファイルは1つである必要があります）。
    *   **内容**: AIが解析したプログラムのドキュメント。以下の情報が含まれます（`--program_type` の設定によって内容は異なります）。
        *   **`main` タイプの場合 (デフォルト)**:
            1.  プログラムの動作
            2.  必要な非標準ライブラリとインストールコマンドとインストール方法
            3.  必要な入力ファイル
            4.  実行後に生成される出力ファイル
            5.  コマンドラインでの使用例 (Usage)
        *   **`lib` タイプの場合**:
            1.  このライブラリの主な機能や目的
            2.  このライブラリを他のプログラムからimportする方法
            3.  必要な非標準ライブラリとインストールコマンドとインストール方法
            4.  importできる変数と関数（説明コメント、動作、引数、戻り値）
            5.  main scriptとして実行したときの動作

### 5) コマンドラインでの使用例 (Usage)

`explain_program5.py` は、以下の書式で実行します。

```bash
python explain_program5.py [--api {openai,openai5,google,gemini}] [{-t --program_type} {main,lib}] [{-u --update} {0,1}] [{-w --overwrite} {0,1}] <pattern> [output]
```

**引数:**

*   `<pattern>` (必須): 処理対象ファイルのワイルドカードパターン（例: `'*.py'`, `'my_program.py'`, `'src/*.c'`）。
*   `[output]` (任意): 出力Markdownファイル名。省略した場合は入力ファイルごとに拡張子が `.md` に置換されます。複数ファイルを処理する場合は省略する必要があります。

**オプション:**

*   `--api {openai, openai5, google, gemini}`: 使用するAI APIを指定します。
    *   `openai`: OpenAIの `gpt-4o` など。
    *   `openai5`: OpenAIの `gpt-5-nano` など。
    *   `google` (デフォルト), `gemini`: Google Gemini。
*   `-t {main, lib}`, `--program_type {main, lib}`: プログラムのタイプを明示的に指定します。
    *   `main`: メインスクリプトとして解析します。
    *   `lib`: ライブラリとして解析します。
    *   デフォルトは空文字列で、ファイル名や拡張子に基づいて自動判別されます（例: `.pm` や `tk` で始まるファイルは `lib`、それ以外は `main`）。
*   `-u {0,1}`, `--update {0,1}`: 出力ファイルが存在し、かつ入力ファイルより古い場合にのみ再生成します。`0` (デフォルト) は無効、`1` は有効です。
*   `-w {0,1}`, `--overwrite {0,1}`: 既存の出力ファイルを問答無用で上書き生成します。`0` (デフォルト) は無効、`1` は有効です。

**使用例:**

1.  **現在のディレクトリにある全てのPythonスクリプトをGoogle Gemini APIで解析し、Markdownドキュメントを生成する（デフォルト動作）:**
    ```bash
    python explain_program5.py "*.py"
    ```

2.  **特定のPythonスクリプトをOpenAI GPT-4o APIで解析し、`my_script_doc.md` というファイル名で出力する。既存ファイルは上書きする:**
    ```bash
    python explain_program5.py --api openai -w 1 my_script.py my_script_doc.md
    ```

3.  **`utils.py` というファイルをライブラリとして解析し、OpenAI GPT-5-nano APIを使用する。出力ファイルが入力ファイルより古い場合のみ更新する:**
    ```bash
    python explain_program5.py --api openai5 -t lib -u 1 utils.py
    ```

4.  **C言語のソースコードをGoogle Gemini APIで解析し、デフォルトの出力ファイル名（例: `main.c` → `main.md`）で生成する:**
    ```bash
    python explain_program5.py main.c
    ```

5.  **複数のGo言語ファイル（`go_src` ディレクトリ内）をGoogle Gemini APIで解析する:**
    ```bash
    python explain_program5.py "go_src/*.go"
    ```