import os
import sys
from dotenv import load_dotenv
import pathlib
import chardet
import google.generativeai as genai

from tkai_lib import *


config_path = "translate.env"

input_path = "input.txt"
output_path = None

gemini_model = 'gemini-2.5-flash'
show_api_key = True

model = genai.GenerativeModel(gemini_model)

read_ai_config(config_path)
if show_api_key:
    print(f"GOOGLE_API_KEY: {os.environ.get('GOOGLE_API_KEY', 'not set')}")
    print(f"OPENAI_API_KEY: {os.environ.get('OPENAI_API_KEY', 'not set')}")

argv = sys.argv
nargv = len(argv)
if nargv > 1:
    input_path = argv[1]
if nargv > 2:
    output_path = argv[2]

if output_path is None:
    #input_pathからdir,filebodyを取得し、{dir}/{filebody}-corrected.txtとする
    input_file = pathlib.Path(input_path)
    output_path = os.path.join(input_file.parent, f"{input_file.stem}-corrected.txt")

print()
print(f"入力ファイル: {input_path}")
print(f"出力ファイル: {output_path}")

try:
    genai.configure(api_key=os.environ["GOOGLE_API_KEY"])
except KeyError:
    print("APIキーが設定されていません。環境変数 'GEMINI_API_KEY' を設定してください。")
    exit()

def correct_semiconductor_text(input_path: str, output_path: str):
    """
    半導体専門家として文字起こしテキストの誤字・誤変換を修正し、講義として適切な内容に変換します。

    Args:
        input_path (str): 読み込む入力ファイルのパス。
        output_path (str): 結果を保存する出力ファイルのパス。
    """

    print()
    print("文字コード判定")
    try:
        with open(input_path, "rb") as f:
            raw = f.read()
            result = chardet.detect(raw)
            encoding = result['encoding']
            print(f"推定文字コード: {encoding}")
    except FileNotFoundError:
        print(f"エラー: 入力ファイル '{input_path}' が見つかりません。")
        return
    except Exception as e:
        print(f"入力ファイルの読み込み中にエラーが発生しました: {e}")
        return

    print("入力ファイル読み込み")
    try:
        with open(input_path, 'r', encoding=encoding) as f:
            transcript = f.read()
    except Exception as e:
        print(f"入力ファイルの読み込み中にエラーが発生しました: {e}")
        return

    prompt = f"""
    あなたは半導体の専門家で、特に専門用語の使い方については熟知しています。
    以下の文章は文字起こしをしたもので多くの誤字・誤変換を含んでいますが、文脈を理解し、半導体専門家の講義として適切な内容に直してください。
    発言者を推測するとともに、なるべくもとの発言の文章に忠実に単語等を修正してください。全ての文章の修正をお願いします

    ---
    文字起こしテキスト:
    {transcript}
    ---

    修正後テキスト（発言者と講義内容として自然な形に修正）:
    """

    print("AIによる修正中...")
    try:
        response = model.generate_content(prompt)
        corrected_text = response.text
    except Exception as e:
        print(f"AIによるテキスト修正中にエラーが発生しました: {e}")
        return

    try:
        with open(output_path, 'w', encoding='utf-8') as f:
            f.write(corrected_text)
        print(f"修正されたテキストが '{output_path}' に保存されました。")
    except Exception as e:
        print(f"出力ファイルの書き込み中にエラーが発生しました: {e}")

if __name__ == "__main__":
    correct_semiconductor_text(input_path, output_path)