# correct_transcript.py ドキュメント

## 1) プログラムの動作
`correct_transcript.py` は、半導体に関する文字起こしテキストの誤字や誤変換を修正するプログラムです。指定された入力ファイルを読み込み、AIを用いて内容を適切な形に修正し、修正後のテキストを出力ファイルに保存します。プログラムは以下の手順で動作します：

1. 環境変数からAPIキーを読み込み、AIモデルを設定します。
2. コマンドライン引数から入力ファイルと出力ファイルのパスを取得します。
3. 入力ファイルの文字コードを判定し、テキストを読み込みます。
4. 読み込んだテキストをAIに渡し、修正を行います。
5. 修正されたテキストを指定された出力ファイルに保存します。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムは以下の非標準ライブラリを使用しています：

- `python-dotenv`: 環境変数を管理するためのライブラリ
- `chardet`: 文字コードを判定するためのライブラリ
- `google-generativeai`: Googleの生成AIを使用するためのライブラリ
- `tkai_lib`: プログラム内で使用されるカスタムライブラリ（詳細は不明）

### インストール方法
以下のコマンドを使用して必要なライブラリをインストールできます：

```bash
pip install python-dotenv chardet google-generativeai
```

## 3) 必要な入力ファイル
プログラムは以下の入力ファイルを必要とします：

- `input.txt`: 修正対象の文字起こしテキストが含まれるファイル。プログラム実行時にコマンドライン引数として指定するか、デフォルトで使用されます。

## 4) 実行後に生成される出力ファイル
プログラム実行後に生成される出力ファイルは以下の通りです：

- `-corrected.txt` という接尾辞が付いたファイル。これは、修正されたテキストが保存されるファイルで、元の入力ファイルと同じディレクトリに作成されます。

## 5) コマンドラインでの使用例 (Usage)
プログラムはコマンドラインから以下のように実行します：

```bash
python correct_transcript.py [input_file] [output_file]
```

- `input_file`: 修正対象の入力ファイルのパス（省略可能、デフォルトは `input.txt`）。
- `output_file`: 修正後のテキストを保存する出力ファイルのパス（省略可能、デフォルトは `input_file` の名前に `-corrected.txt` を付けたもの）。

### 例
```bash
python correct_transcript.py input.txt output.txt
```

このコマンドは、`input.txt` を修正し、結果を `output.txt` に保存します。