# check_whisper.py プログラム解析

## 1) プログラムの動作

このPythonスクリプトは、OpenAIのWhisperモデルを使用して、指定された音声ファイルを日本語で文字起こしし、その結果を標準出力に表示します。

主な動作は以下の通りです。
1.  **GPUの確認**: PyTorchライブラリを使用し、CUDA (GPU) が利用可能かを確認し、その結果を標準出力に表示します。これは、WhisperモデルをGPU上で実行できるかどうかの指標となります。
2.  **Whisperモデルのロード**: OpenAI Whisperの「medium」モデルをダウンロードしてロードし、利用可能な場合はGPU (`cuda`) にモデルを配置します。GPUが利用できない場合（`torch.cuda.is_available()` が `False` の場合）でも、`to("cuda")` が指定されているため、通常はエラーが発生します。
3.  **音声ファイルの文字起こし**: スクリプト内にハードコードされたファイル名 `your_audio_file.mp3` の音声ファイルを、日本語 (`language="ja"`) として文字起こしします。
4.  **結果の表示**: 文字起こしされたテキスト (`result["text"]`) を標準出力に表示します。

## 2) 必要な非標準ライブラリとインストールコマンドとインストール方法

このプログラムを実行するには、以下の非標準ライブラリが必要です。

1.  **PyTorch (`torch`)**
    *   **説明**: ディープラーニングフレームワーク。Whisperモデルの実行基盤となります。特にGPUを使用する場合は、CUDA対応版のインストールが必須です。
    *   **インストール方法**: PyTorchの公式サイト ([https://pytorch.org/get-started/locally/](https://pytorch.org/get-started/locally/)) で、ご自身の環境（OS, pip/conda, CUDAバージョンなど）に合わせた正確なコマンドを確認し、実行してください。
        *   **例 (CUDA 11.8 の場合)**:
            ```bash
            pip install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu118
            ```
        *   **例 (CPU のみの場合 - プログラムは `to("cuda")` でエラーになる可能性あり)**:
            ```bash
            pip install torch torchvision torchaudio
            ```

2.  **OpenAI Whisper (`whisper`)**
    *   **説明**: OpenAIが開発した汎用音声認識モデルのPythonラッパー。
    *   **インストールコマンド**:
        ```bash
        pip install openai-whisper
        ```

### 補足: FFmpegのインストール

Whisperライブラリは、音声ファイルの読み込みに `ffmpeg` という外部ツールを内部的に利用します。ほとんどの環境で必要となるため、まだインストールされていない場合は、以下の方法でシステムにインストールしてください。

*   **Windows**:
    1.  FFmpegの公式サイト ([https://ffmpeg.org/download.html](https://ffmpeg.org/download.html)) から適切なバイナリをダウンロードします。
    2.  ダウンロードしたファイルを解凍し、`bin` ディレクトリへのパスをシステムの環境変数 `PATH` に追加します。
*   **macOS (Homebrewを使用)**:
    ```bash
    brew install ffmpeg
    ```
*   **Linux (aptを使用)**:
    ```bash
    sudo apt update
    sudo apt install ffmpeg
    ```
*   **Linux (yumを使用)**:
    ```bash
    sudo yum install ffmpeg
    ```

## 3) 必要な入力ファイル

プログラムの実行には、以下の音声ファイルが必要です。

*   `your_audio_file.mp3`: 文字起こししたい音声ファイル。スクリプトが実行されるディレクトリにこの名前で配置するか、スクリプト内のファイルパスを正確に指定する必要があります。プログラムコードでは `.mp3` 拡張子を想定していますが、WhisperはWAV, M4Aなどの他の多くの音声形式もサポートします。

## 4) 実行後に生成される出力ファイル

このプログラムは、実行後に**ファイルは生成しません**。
文字起こしの結果は、標準出力 (コンソール) にテキストとして表示されるのみです。

## 5) コマンドラインでの使用例 (Usage)

プログラムを実行する前に、上記の必要なライブラリとFFmpegをインストールし、文字起こし対象の音声ファイル (`your_audio_file.mp3`) をスクリプトと同じディレクトリに配置してください。

```bash
python check_whisper.py
```

**実行例（出力）:**

```
touch.cuda.is_available: True
whisper model: こんにちは、これはテスト音声です。
```
(注: `touch.cuda.is_available` の値は環境によって異なり、`False` の場合はGPUが利用できません。その場合、`to("cuda")` でエラーが発生するか、CPUにフォールバックするためにコードの変更が必要になります。`whisper model` の後のテキストは `your_audio_file.mp3` の内容によって変わります。)