# OCR_pdf.py Documentation

## 1. プログラムの動作
このプログラムは、指定されたPDFファイルからテキストを抽出するためにOCR（光学文字認識）を使用します。プログラムは以下の手順で動作します：

1. PDFファイルを開き、各ページを画像としてレンダリングします。
2. 各画像に対してOCRを実行し、テキストを抽出します。
3. 抽出されたテキストを連結し、最終的に出力します。
4. 一時的に生成された画像ファイルは、OCR処理後に削除されます。

## 2. 必要な非標準ライブラリとインストールコマンド
このプログラムを実行するためには、以下の非標準ライブラリが必要です。

- Pillow
- PyMuPDF
- pytesseract

これらのライブラリは、以下のコマンドでインストールできます：

```bash
pip install Pillow PyMuPDF pytesseract
```

### Tesseract OCRのインストール
また、`pytesseract`を使用するためには、Tesseract OCRエンジンを別途インストールする必要があります。Windowsの場合、以下のリンクからダウンロードできます：

- [Tesseract OCR for Windows](https://tesseract-ocr.github.io/tessdoc/Downloads.html)

インストール後、Tesseractの実行ファイルのパスを環境変数に追加する必要があります。

## 3. 必要な入力ファイル
プログラムは、`peak_fit.pdf`という名前のPDFファイルを入力として使用します。このファイルが存在しない場合、プログラムはダミーPDFを自動的に生成します。

## 4. 実行後に生成される出力ファイル
プログラムは、OCR処理の結果をコンソールに出力します。出力は、各ページのOCR結果を含むテキストの連結です。生成された一時画像ファイルは、OCR処理後に削除されるため、出力ファイルは存在しません。

## 5. コマンドラインでの使用例 (Usage)
プログラムは、コマンドラインから直接実行できます。以下のコマンドを使用して実行します：

```bash
python OCR_pdf.py
```

このコマンドを実行すると、`peak_fit.pdf`が存在する場合はそのファイルからOCRを実行し、存在しない場合はダミーPDFを生成してOCRを実行します。出力はコンソールに表示されます。