# OCR_image.py プログラムドキュメント

## 1) プログラムの動作
このプログラムは、指定された画像ファイルから文字を認識し、抽出されたテキストをコンソールに出力します。Tesseract OCRエンジンを使用しており、日本語と英語の両方のテキストを認識することができます。指定された画像ファイルが存在しない場合は、テスト用のダミー画像を生成します。

## 2) 必要な非標準ライブラリとインストールコマンド
このプログラムを実行するためには、以下の非標準ライブラリが必要です。

- Pillow
- PyMuPDF
- pytesseract

### インストールコマンド
```bash
pip install Pillow PyMuPDF pytesseract
```

### インストール方法
上記のコマンドをターミナルまたはコマンドプロンプトで実行することで、必要なライブラリをインストールできます。

## 3) 必要な入力ファイル
プログラムは、`IMG_8583.jpg` という名前の画像ファイルを入力として使用します。このファイルが存在しない場合、プログラムは自動的にダミー画像を生成します。

## 4) 実行後に生成される出力ファイル
このプログラムは、特にファイルを生成しませんが、OCR処理の結果として抽出されたテキストをコンソールに出力します。ダミー画像が生成された場合、その画像ファイル `IMG_8583.jpg` が作成されます。

## 5) コマンドラインでの使用例 (Usage)
プログラムを実行するには、以下のコマンドを使用します。

```bash
python OCR_image.py
```

実行後、指定された画像ファイルからOCRを行い、結果をコンソールに表示します。画像ファイルが存在しない場合は、ダミー画像が生成され、その後OCR処理が行われます。