# AI Assistant Program Documentation

## 1. プログラムの動作
このプログラムは、ユーザーが指定したテキストファイルを読み込み、OpenAIまたはGoogleのAPIを使用してAIにクエリを送信し、その応答を出力ファイルに保存するためのGUIアプリケーションです。ユーザーはエディタの実行可能ファイル、入力ファイル、出力ファイル、APIの選択、モデル、プロンプト、温度、最大バイト数などの設定を行うことができます。アプリケーションは、設定をINIファイルに保存し、次回起動時に読み込むことができます。

## 2. 必要な非標準ライブラリとインストールコマンド
以下の非標準ライブラリが必要です。これらは、次のコマンドを使用してインストールできます。

```bash
pip install tkinter ttkthemes openai google-generativeai python-dotenv
```

- `tkinter`: GUIを作成するためのライブラリ
- `ttkthemes`: tkinterのテーマを提供するライブラリ
- `openai`: OpenAI APIを使用するためのライブラリ
- `google-generativeai`: Googleの生成AI APIを使用するためのライブラリ
- `python-dotenv`: 環境変数を管理するためのライブラリ

## 3. 必要な入力ファイル
- `roles.ini`: AIの役割に関する設定を含むINIファイル。各役割は`desc`と`prompt`のペアで定義されます。
- `prompt.ini`: プロンプトテンプレートに関する設定を含むINIファイル。各テンプレートは`desc`と`prompt`のペアで定義されます。
- `accounts.env`: APIキーなどのアカウント情報を含む環境変数ファイル。

## 4. 実行後に生成される出力ファイル
- 指定された出力ファイルパスにAIの応答が保存されます。デフォルトでは、入力ファイル名に`-output`を付加した名前で保存されます（例: `input-output.txt`）。

## 5. コマンドラインでの使用例 (Usage)
プログラムを実行するには、以下のコマンドを使用します。

```bash
python AI_assistant.py
```

### GUIの使用方法
1. **Editor Executable**: 使用するエディタの実行可能ファイルを指定します。
2. **Input Text File**: 入力ファイルを選択します。
3. **Output File**: 出力ファイルのパスを指定します。
4. **API Settings**: 使用するAPI（OpenAIまたはGoogle）を選択し、モデルを選択します。
5. **Role & Prompt Settings**: 役割とプロンプトテンプレートを選択します。
6. **Parameters**: 温度と最大バイト数を設定します。
7. **Query AI**: 「Query AI」ボタンをクリックしてAIにクエリを送信します。
8. **Close**: アプリケーションを閉じるには「Close」ボタンをクリックします。

このプログラムは、ユーザーがAIとインタラクションし、結果をファイルに保存するための便利なツールです。