import os
import sys
import platform
import re

# os.path.exists(path)
# os.path.isfile(path)
# os.path.isdir(path)
# os.path.dirname(__file__)

OSName = os.name

# python script name
ScriptName = __file__
Program         = os.path.basename(__file__)

OS         = platform.system()    # macOS: Darwin  Windows: Windows  Ubuntu: Darwin
OSRelease  = platform.release()   # macOS: 18.2.0  Windows: 10
OSVersion  = platform.version()   # macOS: Darwin-18.2.0-x86...  Windows: 10.0.17763
OSPlatform = platform.platform()  # macOS: Darwin-18.2.0-x86_64-i386-64bit  Windows: Windows-10-10.0.17763-SP0

script_path = sys.argv[0]
script_dir  = os.path.dirname(os.path.abspath(script_path))
dir = script_dir
for i in range(10):
    dir2 = os.path.dirname(dir)
    if 'tkprog_' in dir2:
        dir = dir2
        continue
    else:
        break

#print("script_path=", script_path)
#print("script_dir=", script_dir)
tkProg_Root   = os.environ.get("tkProg_Root", None)
if tkProg_Root is None:
    print()
    print(f"Warning in tkprogvars.py: Environment variable tkProg_Root is not given")
    print(f"   tkProg_Root is speculated from the script path [{os.path.abspath(script_path)}]")
    print()
#    input("Press ENTER to terminate>>\n")
#    exit()
    tkprog_X_path = os.path.dirname(script_dir)
    tkProg_Root = os.path.dirname(tkprog_X_path)
else:
    tkprog_X_path = os.environ.get("tkprog_X_path", os.path.join(tkProg_Root, 'tkprog_Linux'))

tkprog_path   = os.environ.get("tkprog_path", os.path.join(tkProg_Root, 'tkprog'))
tkapp_path    = os.environ.get("tkapp_path", os.path.join(tkProg_Root, 'tkapp'))
BinDir        = os.path.join(tkProg_Root, 'bin')
DBDir         = os.path.join(tkProg_Root, 'tkdb', 'Databases')

ProgramDir = tkProg_Root

#print("tkProg_Root=", tkProg_Root)
#print("ProgramDir=", ProgramDir)
#print("BinDir=", BinDir)

AtomDBDir = os.path.join(DBDir, 'atoms')
VESTADBDir = os.path.join(DBDir, 'VESTA')

RietanDir = os.path.join(tkapp_path, 'XRD', 'RIETAN-FP')

VASPDir       = os.path.join(tkprog_X_path, "VASP")
VASPPythonDir = os.path.join(tkprog_X_path, 'VASP')
VASPPerlDir   = os.path.join(tkprog_path, 'Perl', 'VASP')


"""
DBDir = os.environ.get("TkDatabasesDir", None)
if DBDir is None:
    DBDir = os.path.join(ProgramDir, 'tkdb', 'Databases')
if not os.path.isdir(DBDir):
    DBDir = os.path.join(BinDir, 'Databases')

if not os.path.isdir(DBDir):
    DBDir = "d:\\tkProg.main\\tkdb\\Databases"
if os.path.isdir(DBDir):
    ProgramDir = "d:\\tkProg.main\\tklib"
    BinDir = os.path.join(ProgramDir, 'bin')
else:
    DBDir = "d:\\tkProg\\tkdb\\Databases"
    ProgramDir = "d:\\tkProg\\tklib"
    BinDir = os.path.join(ProgramDir, 'bin')
"""


"""
if OS == 'Linux':
    ProgramDir = os.environ.get("ProgramDir")
    BinDir     = os.environ.get("BinRoot")
    if BinDir is None and ProgramDir is not None:
        BinDir = os.path.join(ProgramDir, 'bin')
else:
    ProgramDir = os.environ.get("ProgramDir", None)
    BinDir     = os.environ.get("BinRoot", None)
    
    if ProgramDir is None or not os.path.isdir(ProgramDir):
        ProgramDir = tkProg_Root

    if ProgramDir is None or not os.path.isdir(ProgramDir):
        ProgramDir = "d:\\tkProg\\tklib"
    if not os.path.isdir(ProgramDir):
        ProgramDir = "c:\\tkProg\\tklib" 
    if not os.path.isdir(ProgramDir):
        ProgramDir = "d:\\Programs"
    if not os.path.isdir(ProgramDir):
        ProgramDir = "c:\\Programs" 

    if BinDir is None or not os.path.isdir(BinDir):
        BinDir = os.path.join(ProgramDir, 'bin')
"""


def system(cmd):
    os.system(cmd)

def getenv():
    return os.environ

def setenv(varname, value):
    os.environ[varname] = value

def mkdir(path):
    os.mkdi(path)

def rename(oldpath, newpath):
    os.rename(oldpath, newpath)
    
def remove(path):
    os.remove(path)

def creation_date(path):
    """
    Try to get the date that a file was created, falling back to when it was
    last modified if that isn't possible.
    See http://stackoverflow.com/a/39501288/1709587 for explanation.
    """
    if platform.system() == 'Windows':
        return os.path.getctime(path)
    else:
        stat = os.stat(path)
        try:
            return stat.st_birthtime
        except AttributeError:
            # We're probably on Linux. No easy way to get creation dates here,
            # so we'll settle for when its content was last modified.
            return stat.st_mtime
