try:
    from importlib import import_module
except:
    print("\nError: Failed to import [importlib] module.\n")
    input("\nPress ENTER to terminate>>\n\n")
    exit()


from tklib.tkobject import tkObject


imported_modules = {}
error_modules = {}

def import_lib(module_name, stop_by_error = True):
    if module_name in imported_modules.keys():
        return imported_modules[module_name]

    try:
        module = import_module(module_name)
        imported_modules[module_name] = module
    except Exception as e:
        error_modules[module_name] = str(e)
        if stop_by_error:
            print()
            print("###################################################################################")
            print("###################################################################################")
            print(f"Error: Failed to import [{module_name}] module ({e}).\n")
            print(f"  Install [{module_name}] using pip, pip3 or conda for anaconda. For exmaple,")
            print(f"      pip install {module_name}")
            print("###################################################################################")
            print("###################################################################################")
            input( "\nPress ENTER to terminate>>\n\n")
            exit()
        else:
            print(f"\nWarning: Failed to import [{module_name}] module ({e}).\n")
            print(  f"Functions included in [{module_name}] will not work\n")
            return None
    return module

def messages(stop_by_error = True):
    if len(error_modules) == 0:
        return True

    names = list(error_modules.keys())

    print("###################################################################################")
    print("###################################################################################")
    if stop_by_error:
        print(f"Fatal errors in previous imports:")
    else:
        print(f"Warnings in previous imports:")

    for name, e in error_modules.items():
        print(f"  Failed to import [{name}] module ({e})")
    
    print(f"  Install the above modules using pip, pip3, or conda for anaconda. For exmaple:")
    print(f"      pip install {names[0]}")
    if stop_by_error:
        print("###################################################################################")
        print("###################################################################################")
        input( "\nPress ENTER to terminate>>\n\n")
        exit()
    else:
        print("###################################################################################")
        print("###################################################################################")
        print()
    
    return False