import tkinter

class tkMenu_popup:
    def __init__(self, parent = None, app = None, title = '', submenus = []):
        self.parent = parent
        self.app = app
        self.title = title
        self.shifty = 0
        self.shifty = 0
        self.menu = self.create_menu(submenus)

    def create_menu(self, submenus):
        self.submenus = submenus.copy()
        self.menu = tkinter.Menu(self.parent, tearoff = 0)

        for i in range(len(submenus)):
            self.menu.add_command(label = self.submenus[i]['label'], command = self.submenus[i]['callback'])

        return self.menu

    def show(self, event):
#       x = event.x
#       y = event.y
        x = self.widget.winfo_rootx() + self.shifty
        y = self.widget.winfo_rooty() + self.shifty
        self.menu.post(x, y)

    def hide(self, event):
        self.menu.unpost()

    def bind_to_widget(self, widget, shiftx = 0, shifty = 0):
        self.widget = widget
        self.shiftx = shiftx
        self.shifty = shifty

#       widget.bind("<Button-1>", show_menu)
        widget.bind('<Enter>', self.show)
        widget.bind('<Leave>', self.hide)
#       widget.bind("<Motion>", self.motion)


def main():
    root = tk.Tk()

    menu = tkMenu_popup(root, 'test')

    root.mainloop()

if __name__ == "__main__":
    main()
