import csv
import re

from tklib.tkutils import pint, sort_lists
from tklib.tkfile import tkFile
from tklib.tkinifile import tkIniFile
import tklib.tkre as tkre




class tkDataFile(tkFile):
    """ 
    tklib Data File class
    """

    def __init__(self, path = None, mode = 'r', OpenFile = True, **args):
        super().__init__(path = path, mode = mode, OpenFile = OpenFile, **args)
#        super(tkIniFile, self).__init__(path, mode, OpenFile, **args)

        self.labelarray    = []
        self.datalistarray = []

    def __del__(self):
        self.Close()
        super(tkIniFile, self).__del__()

    def __str__(self):
        return self.ClassPath()


    def GetArrayData(self, idx):
        pass

    def GetHashData(self):
        pass

    def sort(self, lists):
        return sort_lists(lists)
    
    def find_label_index(self, regexp, flag = None, flags = ''):
        if flags == '' and flag is not None:
            flags = flag

#        print("labels=", self.labelarray)
#        print("reg=", regexp)
        if type(regexp) is int:
            return regexp
        else:
            idx = pint(regexp, None)
            if idx is not None:
                return int(regexp)

        if flags == 'i':
            flags = re.IGNORECASE

        regexp_nosp = re.sub(r'[\[\(]', '(', regexp, flags = flags)
        regexp_nosp = re.sub(r'[\]\)]', ')', regexp_nosp, flags = flags)
        regexp_nosp = re.sub(r'\s', '', regexp_nosp, flags = flags)

        for i in range(len(self.labelarray)):
#            print("  i=", i, regexp, self.labelarray[i])
            if regexp == self.labelarray[i]:
                return i

            s_nosp = re.sub(r'[\[\(]', '(', self.labelarray[i])
            s_nosp = re.sub(r'[\]\)]', ')', s_nosp)
            s_nosp = re.sub(r'\s', '', s_nosp)
            if regexp_nosp == s_nosp:
                return i
            if tkre.Search(regexp, self.labelarray[i], flag):
                return i
        return None

    def find_data_array(self, regexp, flag = None, flags = '', convert_type = None, def_val = None, ):
#        print("regexp=", regexp)
#        print("labels=", self.labelarray)
#        print("data=", self.datalistarray)
#        print("regexp=", regexp)

        if type(regexp) is int:
            idx = regexp
        else:
            idx = pint(regexp, defval = None)
            if idx is None:
                idx = self.find_label_index(regexp = regexp, flag = flag, flags = flags)

        if len(self.labelarray) < idx + 1:
            return None, None
        
        if convert_type is None:
            return self.labelarray[idx], self.datalistarray[idx]
        else:
            data = self.datalistarray[idx].copy()
            for i in range(len(data)):
                if convert_type is float:
                    data[i] = pfloat(data[i], data[i])
                elif convert_type is int:
                    data[i] = pint(data[i], data[i])
            return self.labelarray[idx], data

    def FindLabelIndex(self, regexp, flag = None, flags = ''):
        return self.find_label_index(regexp = regexp, flag = flag, flags = flag)

    def FindDataArray(self, regexp, flag = None, flags = ''):
        return self.find_data_array(regexp = regexp, flag = flag, flags = flags)

    def read_data(self, idata = [], flags = '', convert_type = None, def_val = None, is_print = True):
        labels = []
        data_list = []
        for idx in idata:
            label, data = self.find_data_array(regexp = idx, flags = flags, convert_type = convert_type, def_val = def_val)
            labels.append(label)
            data_list.append(data)

        return labels, data_list

 