import sys
import argparse


from tklib.tkobject import tkObject



class tkArgs(argparse.ArgumentParser, tkObject):
    """ 
    Arguments class, inherited from argparse.ArgumentParser and tkObject
    """

    def __init__(self, program_file = None, program_path = None, version = None, 
                 author = None, creation_date = None, last_update_date = None, **kwargs):
        if program_file:
            self.program_file = program_file
        else:
            self.program_file = sys.argv[0]
        self.program_path     = program_path
        self.version          = version
        self.author           = author
        self.creation_date    = creation_date
        self.last_update_date = last_update_date
        self.update(**kwargs)

    def initialize(self, **kwargs):
        super().__init__(**kwargs)

#    def __del__(self):
#        print("{} destroyed".format(self.name))

    def __str__(self):
        return "optimization object by {}".format(self.method)


    def checkkwargs(self, nargs = '?', **kwargs):
        try:
            if kwargs["action"] == 'version':
                pass
        except:
            kwargs["nargs"] = nargs
        return kwargs

    def add_arg(self, key1, key2 = None, nargs = '?', **kwargs):
        self.checkkwargs(nargs = nargs, **kwargs)

        """
        print(key1, ":")
        print("  ", kwargs)
        print("")
        """
        
        if key2 is None:
            super().add_argument(key1, **kwargs)
        else:
            super().add_argument(key1, key2, **kwargs)

    def add_floatarg(self, key1, key2 = None, nargs = '?', type = float, **kwargs):
        if key2 is None:
            super().add_argument(key1, nargs = nargs, type = type, **kwargs)
        else:
            super().add_argument(key1, key2, nargs = nargs, type = type, **kwargs)
        
    def add_intarg(self, key1, key2 = None, nargs = '?', type = int, **kwargs):
        if key2 is None:
            super().add_argument(key1, nargs = nargs, type = type, **kwargs)
        else:
            super().add_argument(key1, key2, nargs = nargs, type = type, **kwargs)

    def print_args(self,print_attributes = 0, print_args = 1):
        if print_attributes:
            self.print_attributes(1)
        if print_args:    
            print("args: ", self.parse_args())
        