"""
## Information
Author: Ryusei Higuchi
Contact: r-higuchi@mces.titech.ac.jp
Date: 2023-10-20
Version: 1.0.0
Git URL: https://github.com/kamiya-kataselab/colormap/blob/main/Ryu_colormap.py
Description: This script provides a custom colormap for data visualization.
"""

#from matplotlib.colors import ListedColormap
#import matplotlib as mpl
#import matplotlib.pyplot as plt
import numpy as np


colors = [(150/255, 0, 0), (214/255, 0, 0), (214/255, 127/255, 0), (234/255, 189/255, 0),
          (51/255, 204/255, 51/255),(0, 153/255, 0),(0, 176/255, 172/255),
          (0, 51/255, 204/255),(153/255, 51/255, 255/255), (230/255, 0 , 230/255)]

def Ryu_color():
    Ryu_colormap = ListedColormap(colors, name="Ryu_colormap")

    mpl.colormaps.register(Ryu_colormap)

def main():
    # 定義したカラーマップを呼び出します。
    Ryu_color()
    ryu_cmap = plt.get_cmap("Ryu_colormap")

    # カラーマップを表示するためのデータを作成します。
    data = np.array([[i for i in range(len(ryu_cmap.colors))]])

    # カラーマップを表示します。
    fig, ax = plt.subplots(1, 1, figsize=(5, 2))
    cbar = ax.imshow(data, cmap=ryu_cmap)

    # 横軸を1間隔で目盛りを表示
    ax.set_xticks(np.arange(0, 10, 1))
    # 縦軸の目盛りと数字を表示しない
    ax.set_yticks([])
    ax.set_yticklabels([])

    plt.show()

if __name__ == "__main__":
    main()
