Good morning, everyone. My name is [Your Name], a Ph.D. student from Tokyo Institute of Technology. I am honored to present our recent work on the fabrication of polycrystalline silicon thin films by a two-step growth method, focusing on structural control and properties through surface reaction control.

**[Slide 1: Title Slide - Fabrication of Polycrystalline Silicon Thin Films by a Two-Step Growth Method]**

Good morning, everyone. My name is [Your Name], and I am a Ph.D. student at Tokyo Institute of Technology. Today, I would like to present our research titled "Fabrication of Polycrystalline Silicon Thin Films by a Two-Step Growth Method: Structural Control and Properties through Surface Reaction Control." This work was conducted in collaboration with Professor Toshio Kamiya, Koichi Nakahata, Atsushi Mitsuida, Hwa-Kyung Lu, C. M. Fortmann, and Isamu Shimizu.

Here is an outline of my presentation. First, I will discuss the background and motivation for this study. Then, I will introduce our proposed two-step growth method. After that, I will present our experimental results, focusing on the interface structure analyzed by spectroscopic ellipsometry and the influence of seed crystals. Finally, I will summarize our findings. You can see a schematic of our process on the right side of the slide, illustrating the substrate, seed crystal, and the poly-Si grain formation.

**[Slide 2: Background]**

Let's begin with the background. Our research focuses on the fabrication of polycrystalline silicon thin films using the Plasma-Enhanced Chemical Vapor Deposition, or PE-CVD, method with SiF4 as the source gas. This method offers several advantages, including the ability to achieve highly crystalline polycrystalline silicon films at relatively low temperatures, typically between 200 to 350 degrees Celsius. Furthermore, it allows for a high deposition rate of approximately 10 angstroms per second and enables the growth of highly oriented films, for example, films with a preferred (022) orientation on glass substrates.

However, a key challenge in this fabrication process, especially for applications like solar cells or thin-film transistors, is the formation of an amorphous layer at the initial stage of deposition. This amorphous layer can degrade the overall film quality and device performance. To mitigate this issue, various approaches have been investigated, such as the Layer-by-Layer method, and our focus today, the two-step growth method.

**[Slide 3: Two-Step Growth Method]**

Now, I will explain our two-step growth method. This method is designed to overcome the initial amorphous layer formation and enhance film crystallinity and orientation. As illustrated in the diagram, the process involves two distinct stages: the "Seed Crystal Process" and the "Growth Process."

In the first stage, the Seed Crystal Process, we deposit a very thin layer, typically around 100 nanometers thick, of highly crystalline and highly oriented silicon. This is achieved at a relatively high temperature, usually above 360 degrees Celsius. This seed layer acts as a template for subsequent growth.

Following this, in the second stage, the Growth Process, we perform epitaxial-like growth on the previously formed seed crystal layer. This stage is conducted at lower temperatures, typically between 200 and 350 degrees Celsius, and is characterized by a fast deposition rate. The idea is that the high-quality seed layer promotes the growth of a highly crystalline and oriented polycrystalline film even at lower temperatures, essentially extending the crystalline order from the seed. This method combines the benefits of high crystallinity and orientation from the seed layer with the advantages of low-temperature and high-rate deposition for the bulk film, much like a modified Layer-by-Layer approach.

**[Slide 4: Evolution of <e2> during Deposition]**

This slide shows representative data from in-situ spectroscopic ellipsometry measurements, specifically the imaginary part of the pseudodielectric function, denoted as `<e2>`, during the initial phase of thin-film deposition. This `<e2>` parameter, especially at a photon energy of 4.15 eV, is highly sensitive to the crystalline fraction and the interface quality of the growing film. A higher `<e2>` value generally indicates higher crystallinity.

The multiple plots here illustrate the evolution of `<e2>` over time for various SiF4 flow rates – 30, 40, and 50 sccm – during deposition on a P-doped poly-Si substrate. We can observe distinct trends. Initially, `<e2>` values are low, indicating an amorphous-like surface. As deposition proceeds, `<e2>` increases, suggesting the onset of crystallization. The rate and maximum value of this increase can tell us about the speed of crystallization and the final crystalline quality. The figures on the bottom further emphasize structural changes. While the specific conditions for each figure are not detailed here, these plots generically demonstrate how crucial in-situ ellipsometry is for monitoring and optimizing the surface reaction and crystallization process in real-time. For example, comparing different SiF4 flow rates, we can infer that optimizing gas composition is critical for promoting early-stage crystallization and suppressing amorphous layer formation.

**[Slide 5: Objective]**

With that background, the primary objective of this study is twofold.
First, we aim to achieve an epitaxial-like interface between the seed crystal and the subsequently grown polycrystalline thin film using our two-step growth method. This is crucial for obtaining high-quality films.
Second, we will systematically investigate the influence of the crystallinity of the seed layer on the properties of the final grown polycrystalline thin film. Understanding this relationship is vital for optimizing our two-step growth process and achieving desired film characteristics.

**[Slide 6: Experimental Setup]**

To conduct our experiments, we utilize a specialized PE-CVD system, as depicted in this schematic. The core components include a microwave magnetron, which generates plasma, and a susceptor that holds the substrate and allows for precise temperature control. We introduce source gases, specifically SiF4, along with H2 and Ar, through controlled gas flow lines. A shutter is placed between the plasma and the substrate to precisely control the deposition time.

A critical feature of our system is the in-situ spectroscopic ellipsometer. This instrument, consisting of a light source, a modulator, and a detector, allows us to monitor the film growth and surface evolution in real-time. The entire process, including gas flow, process time, and atomic hydrogen treatment, is controlled by a sequencer. The ability to perform in-situ measurements, particularly monitoring `<e2>`, is essential for understanding the dynamic surface reactions and crystallization during deposition.

**[Slide 7: Experimental Methods]**

For structural evaluation of our films, we primarily employ two characterization techniques.
The first is spectroscopic ellipsometry, or SE, which we use for in-situ observation of the deposition process. As mentioned earlier, we specifically monitor the imaginary part of the pseudodielectric function, `<e2>`, at a photon energy of 4.15 eV. This in-situ measurement provides real-time insights into the film's crystallinity, thickness, and interface quality as it grows.
The second technique is X-ray Diffraction, or XRD, which is used for ex-situ structural analysis, providing information about the crystalline phases, orientation, and grain size of the final thin films.

A table here outlines typical deposition conditions used in our experiments. While the specific parameters like gas flow rates, pressure, and substrate temperature are varied to investigate their effects, these represent a baseline. For instance, common conditions for the seed crystal process and the subsequent growth process involve specific ratios of SiF4 and H2, as well as distinct substrate temperatures to optimize each step. The combination of these two powerful techniques allows us to thoroughly understand both the dynamic growth process and the final structural properties of our films.

**[Slide 8: Evolution of <e2> during the Growth Process (Condition 1)]**

Let's look at the evolution of `<e2>` during the growth process under our first set of conditions. In this experiment, the SiF4/H2 ratio was kept consistent for both the seed crystal process and the subsequent growth process. Specifically, the seed layer was deposited using SiF4 at 50 sccm, H2 at 5 sccm, and a seed deposition time of 30 seconds at 380 degrees Celsius. The poly-Si growth process then followed with the same gas flow rates: SiF4 at 50 sccm and H2 at 5 sccm.

As you can see from the graph, the `<e2>` value quickly rises from the initial substrate value, indicating rapid crystallization from the very beginning of the poly-Si growth. This suggests that the seed layer effectively promotes the immediate formation of crystalline material, minimizing the undesirable amorphous incubation layer. The relatively high and stable `<e2>` values throughout the growth indicate good and consistent film crystallinity.

**[Slide 9: Evolution of <e2> during the Growth Process (Condition 2)]**

In this next experiment, we investigated the effect of increasing the SiF4 flow rate during the seed crystal process, while keeping other parameters the same. Here, the seed layer was deposited with an increased SiF4 flow rate of 60 sccm, compared to 50 sccm in the previous slide, still with H2 at 5 sccm and a seed deposition time of 30 seconds at 380 degrees Celsius. The poly-Si growth process again followed with SiF4 at 50 sccm and H2 at 5 sccm.

Comparing this graph to the previous one, we observe a similar rapid increase in `<e2>` at the onset of growth, affirming the effectiveness of the seed layer. However, by increasing the SiF4 flow rate during the seed process, we might expect subtle changes in the seed layer's density or surface morphology, which could slightly influence the initial growth kinetics. The continuous high `<e2>` value confirms the sustained crystalline growth, but a detailed comparison between different seed conditions is necessary to fully understand the impact.

**[Slide 10: Evolution of <e2> during the Growth Process (Condition 3)]**

Moving on, this slide presents the `<e2>` evolution when we further modify the gas flow rates in both the seed and growth processes. Here, the seed layer was deposited with SiF4 at 60 sccm, H2 at 5 sccm, and a seed deposition time of 60 seconds at 380 degrees Celsius. Crucially, for the poly-Si growth process, we increased the H2 flow rate to 10 sccm while maintaining SiF4 at 60 sccm.

The graph shows a very sharp and immediate rise in `<e2>`, reaching high values very quickly. This suggests that increasing the H2 flow rate during the growth process, in conjunction with an optimized seed layer, further enhances the epitaxial-like growth and crystalline quality from the earliest stages. Hydrogen plays a critical role in surface passivation and etching, which can promote crystallization and reduce defects. This result highlights the importance of controlling the SiF4/H2 ratio not only for the seed layer but also for the subsequent bulk film growth to achieve superior crystalline properties.

**[Slide 11: Influence of Seed Crystal on the Structure of Thin Films Fabricated by the Two-Step Growth Method]**

This slide serves as an introduction to our next section, where we will delve deeper into how the characteristics of the initial seed crystal layer directly influence the final structure of the polycrystalline silicon thin film fabricated using our two-step method. The image on the right, which could be an XRD pattern or a cross-sectional SEM image, visually suggests that variations in the seed layer lead to distinct structural features in the grown film. We aim to quantify and explain these observed differences in the subsequent slides.

**[Slide 12: Seed Crystal Dependence of <e2> Evolution during the Growth Process]**

Here, we directly compare the evolution of `<e2>` during the growth process for films grown on two different seed crystal conditions. In both cases, the poly-Si growth process used SiF4 at 60 sccm and H2 at 10 sccm.

The blue curve represents growth on a seed deposited with SiF4 at 60 sccm and H2 at 5 sccm (Seed: 60/5/60).
The red curve represents growth on a seed deposited with SiF4 at 60 sccm and H2 at 10 sccm (Seed: 60/10/60).
Interestingly, when the H2 flow rate during the seed process was increased (red curve), the initial rise in `<e2>` is even faster and reaches a slightly higher steady-state value compared to the blue curve. This indicates that a higher H2 content during the seed crystal formation leads to a superior seed layer, which in turn promotes even more rapid and higher-quality crystalline growth in the subsequent poly-Si layer. This strong dependence on the seed crystal's initial surface quality and crystallinity, as reflected by `<e2>`, underscores its critical role in the overall two-step growth method.

**[Slide 13: Influence of Seed Crystal on the Structure of Thin Films Fabricated by the Two-Step Growth Method]**

Finally, let's examine the ultimate impact of the seed crystal on the final film structure through X-ray Diffraction, or XRD, patterns. These graphs compare the diffraction intensity for the same two seed conditions we just discussed, with the poly-Si growth conditions remaining constant (SiF4: 60 sccm, H2: 10 sccm).

The top plot corresponds to the film grown on a seed crystal fabricated with SiF4 at 60 sccm and H2 at 5 sccm (Seed: 60/5/60).
The bottom plot corresponds to the film grown on a seed crystal fabricated with SiF4 at 60 sccm and H2 at 10 sccm (Seed: 60/10/60).

As you can clearly see, the film grown on the seed prepared with a higher H2 flow rate (bottom plot) exhibits significantly stronger and sharper diffraction peaks. This indicates a higher degree of crystallinity and a more preferred orientation in the final poly-Si thin film. For instance, we typically observe enhanced (220) or (111) peaks depending on the growth conditions, signifying highly oriented growth. The improved crystallinity suggested by the `<e2>` measurements in the previous slide is directly confirmed by these XRD results. This strong correlation demonstrates that optimizing the seed crystal process, particularly by controlling the gas flow rates like H2, is paramount for dictating the structural properties of the entire polycrystalline thin film.

**[Slide 14: Summary]**

To conclude my presentation, I would like to summarize our main findings.

First, we successfully improved the interface structure between the seed layer and the bulk poly-Si film by carefully controlling the gas flow rates in both the seed crystal process and the subsequent growth process. Our in-situ spectroscopic ellipsometry measurements, particularly the `<e2>` evolution, provided clear evidence of this enhanced interfacial quality and rapid crystallization.

Second, our investigations revealed that the structure and quality of the seed crystal significantly influence the final structure of the entire thin film. Specifically, optimizing the seed crystal process, for instance, by adjusting the H2 flow rate, leads to superior seed layers, which in turn promote the growth of highly crystalline and oriented polycrystalline silicon films.

These findings highlight the effectiveness of our two-step growth method in achieving high-quality poly-Si thin films for various applications.

Thank you very much for your attention. I am now happy to take any questions you may have.