# 応用物理学会発表原稿：二段階成長法による多結晶シリコン薄膜の作製－表面反応制御による構造制御と物性－

（東工大・総理工） ○神谷利夫、中畑浩一、三井田淳、盧和敬、C.M.Fortmann、清水勇

## 1. はじめに（スライド1, 2）

皆様、こんにちは。ただいまご紹介にあずかりました、東京工業大学 総合理工学研究科の神谷でございます。本日は、「二段階成長法による多結晶シリコン薄膜の作製－表面反応制御による構造制御と物性－」と題しまして、これまでの研究成果をご報告させていただきます。

まず、研究の背景についてご説明いたします。多結晶シリコン薄膜は、太陽電池や薄膜トランジスタなど、様々なデバイスへの応用が期待される重要な材料です。特に、環境負荷の低減や製造コストの削減の観点から、低温かつ高速での製膜技術が求められています。

我々はこれまで、SiF4原料を用いたプラズマCVD（PE-CVD）法に着目し、多結晶シリコン薄膜の作製に取り組んでまいりました。この方法には、いくつかの大きな利点がございます。一つは、低温（200℃〜350℃）で高結晶性の多結晶シリコンが得られること、二つ目は、約10Å/sという高速で製膜が可能であること、そして三つ目は、基板上に高い配向性を持たせた薄膜を作製できることです。例えば、ガラス基板上でも(022)配向性の高い薄膜が報告されております。

しかしながら、このPE-CVD法を用いた場合、製膜初期にアモルファス層が形成されやすいという課題がありました。この初期アモルファス層は、その後の薄膜全体の結晶性や電気特性に悪影響を及ぼすことが知られており、その低減が重要な研究課題となっておりました。この課題を解決するため、これまでにLayer-By-Layer法や、本研究で用いる二段階成長法といった手法が提案されております。

## 2. 二段階成長法（スライド3）

本研究で採用しております「二段階成長法」について、ご説明いたします。これは、薄膜の初期成長段階を特に重視し、良好な結晶性の種結晶層を形成した後に、その上に高品質な多結晶シリコン薄膜を成長させる手法です。

具体的には、二つのプロセスから構成されます。
まず「種結晶プロセス」です。ここでは、基板上に約100nm程度の非常に薄い種結晶層を形成します。この種結晶層は、高温（通常360℃以上）で製膜することにより、高い配向性と高結晶性を有するように制御されます。図に示しますように、基板上に均一に配向した微細なシリコン結晶が形成されるイメージです。

次に、「成長プロセス」です。種結晶プロセスで形成された高品質な種結晶層をテンプレートとして、その上に多結晶シリコン薄膜を成長させます。この成長プロセスは、低温（200℃〜350℃）で、比較的速い成膜速度を維持しながら行われます。これにより、種結晶層の結晶性を引き継ぎ、全体としてエピタキシャルライクな高品質の多結晶シリコン薄膜を、低温かつ高速で実現することを目指します。

Layer-By-Layer法が成膜と水素プラズマ処理を交互に行うのに対し、二段階成長法は、初期の種結晶形成に特化することで、プロセスを簡略化しつつ、高品質化を図るアプローチと言えます。

## 3. これまでの知見と課題（スライド4）

スライド4には、SiF4原料を用いたPE-CVD法におけるこれまでの製膜データや、先行研究で得られた知見の一部を示しています。これらの図は、SiF4流量や時間といった製膜条件が、初期のアモルファス層の形成やその後の結晶化過程にどのように影響するかを示唆するものです。例えば、ある条件では製膜初期にアモルファス層が厚く形成され、その後の結晶化に時間を要する様子や、逆に別の条件では比較的早く結晶化が進行する様子が示されている可能性があります。これらのデータは、製膜初期のアモルファス層をいかに低減し、かつ高速で結晶成長を促すかという、この分野における重要な課題意識の背景となります。この課題を解決するためには、製膜初期の表面反応を詳細に制御することが不可欠であると認識しております。

## 4. 研究目的（スライド5）

以上の背景を踏まえ、本研究の目的は以下の2点に集約されます。

第一に、二段階成長法において、種結晶と、その上に成長する多結晶薄膜との間で、エピタキシャルライクな界面を実現することです。これにより、種結晶の良好な結晶性を、薄膜全体に効率的に伝播させることを目指します。

第二に、二段階成長法における種結晶の結晶性が、その上に成長する多結晶薄膜全体の構造や物性にどのような影響を与えるかについて、詳細に検討することです。種結晶の品質を系統的に変化させ、最終的な薄膜の構造との相関を明らかにすることで、より高品質な多結晶シリコン薄膜の作製条件を確立したいと考えております。

## 5. 実験装置と方法（スライド6, 7）

実験には、in-situ分光エリプソメータが搭載された独自のプラズマCVD装置を使用しました（スライド6）。この装置は、シーケンサーによってガス流量、プロセス時間、シャッター開閉、マイクロ波電力などが厳密に制御されており、Layer-By-Layer法のような複雑なプロセスや、本研究のような二段階成長法を精密に実行することが可能です。in-situ分光エリプソメータにより、製膜中の薄膜成長や結晶化過程をリアルタイムで観察することができます。

構造評価には、主に分光エリプソメータ（SE）と粉末X線回折（XRD）を用いました（スライド7）。
分光エリプソメータでは、特に光エネルギー4.15eVにおける誘電関数虚数部<e2>の変化をモニタリングしました。この4.15eVのピークは、結晶シリコンに特有の電子遷移に由来し、薄膜中の結晶シリコンの体積割合が高いほど、その値が大きくなります。したがって、<e2>の値は薄膜の結晶性の指標として非常に有効であり、特に初期成長段階におけるアモルファス層から結晶相への転移をin-situで捉えることができます。

典型的な製膜条件としては、SiF4、H2、Arガスを用い、マイクロ波プラズマを印加しました。具体的な流量やプロセス温度については、各実験結果のスライドで示します。

## 6. 実験結果と考察

### 6.1. 成長プロセスにおける<e2>の製膜時間変化と界面構造の改善（スライド8, 9, 10）

それでは、実験結果についてご説明いたします。まず、スライド8では、種結晶プロセスと成長プロセスにおいてSiF4/H2ガス流量比を同じにした場合の、<e2>の製膜時間変化を示しています。
（Seed: SiF4 50 sccm / H2 5 sccm / Ar 30 sccm, 380℃ - poly-Si: SiF4 50 sccm / H2 5 sccm / Ar 30 sccm）
グラフの横軸は製膜時間、縦軸は<e2>の値を示しています。ご覧の通り、製膜初期において<e2>が低い値から徐々に上昇し、ある程度の膜厚で飽和する傾向が見られます。これは、初期にアモルファス層が形成され、それが結晶化していく過程を捉えていると考えられます。しかし、この条件では、<e2>が飽和するまでに比較的時間がかかり、初期界面にアモルファス層が多く存在している可能性を示唆しています。

次に、スライド9をご覧ください。ここでは、種結晶プロセスでのSiF4流量を増大させた条件での<e2>の製膜時間変化を示しています。
（Seed: SiF4 50 sccm / H2 5 sccm / Ar 60 sccm, 380℃ - poly-Si: SiF4 50 sccm / H2 5 sccm / Ar 30 sccm）
種結晶プロセスにおけるAr流量の増大は、プラズマ中のSiF4分解種の生成を促進し、より高密度な種結晶の核生成を促す効果が期待されます。このグラフでは、スライド8の条件と比較して、初期の<e2>の立ち上がりが若干早くなり、より迅速に結晶化が進行していることが示唆されます。これは、種結晶層の初期結晶性が向上したことで、その後の成長がよりスムーズになった可能性を示しています。

さらに、スライド10では、種結晶プロセスに加えて、成長プロセスでのH2流量も増大させた条件での結果を示しています。
（Seed: SiF4 60 sccm / H2 5 sccm / Ar 60 sccm, 380℃ - poly-Si: SiF4 60 sccm / H2 10 sccm / Ar 30 sccm）
H2流量の増大は、プラズマ中での水素ラジカル濃度を上昇させ、表面におけるアモルファス相の選択的なエッチングや、結晶成長種の表面移動度向上に寄与することが知られています。このグラフからは、これまでの条件と比較して、製膜初期の<e2>の立ち上がりが非常に急峻であり、かつ速い時間で高い<e2>値に到達していることが明確に分かります。これは、種結晶プロセスの最適化と、それに続く成長プロセスでのH2流量の調整によって、製膜初期のアモルファス層の形成を大幅に抑制し、エピタキシャルライクな高品質な界面が実現できたことを示しています。つまり、表面反応を制御することで、種結晶上に直接、良好な結晶性の多結晶シリコンが成長していることを示唆する結果です。

### 6.2. 2段階成長法で作製した薄膜の構造に与える種結晶の影響（スライド11, 12, 13）

次に、種結晶の結晶性が最終的な多結晶薄膜の構造にどのように影響するかを検討した結果についてご説明します。

スライド11は、異なる種結晶条件で製膜された多結晶シリコン薄膜のXRDパターンを比較したものです。詳細な図は次のスライドで示しますが、ここでは、種結晶の品質が最終的な薄膜の配向性や結晶性に直接的に影響を与えるという全体像を示しています。

スライド12では、成長プロセスにおける<e2>変化の種結晶依存性を具体的に示しています。（poly-Si: SiF4 60 sccm / H2 10 sccm / Ar 60 sccm）
二つの異なる種結晶条件、すなわち「Seed: 60/5/60（SiF4 60 sccm / H2 5 sccm / Ar 60 sccm）」と「Seed: 60/10/60（SiF4 60 sccm / H2 10 sccm / Ar 60 sccm）」で比較しています。
ご覧の通り、「Seed: 60/10/60」の条件で形成された種結晶を用いた場合、その後の成長プロセスにおける<e2>の立ち上がりが非常に早く、最終的な<e2>の値も高くなっています。これは、種結晶プロセスにおいてH2流量を増大させることで、種結晶自体の結晶性が向上し、その結果、その上に成長する薄膜もより良好な結晶性を示すことを明確に示唆しています。H2流量の増加は、種結晶表面でのアモルファス相の形成を抑制し、より配向性の高い結晶核を形成することに寄与したと考えられます。

この<e2>の結果を裏付けるように、スライド13には、これら異なる種結晶条件で作製された薄膜のXRDパターンを示しています。（poly-Si: SiF4 60 sccm / H2 10 sccm / Ar 60 sccm）
上側のグラフが「Seed: 60/5/60」を用いた薄膜、下側のグラフが「Seed: 60/10/60」を用いた薄膜のものです。
「Seed: 60/10/60」の条件で作製した薄膜では、(220)ピーク強度が顕著に増大していることが分かります。これは、薄膜が(220)配向性を持つ結晶粒で構成されていることを示しており、より高い結晶性と特定の配向性が実現されていることを意味します。一方で、「Seed: 60/5/60」の条件では、(220)ピークの相対強度が低く、結晶性が劣っていることが示唆されます。

これらの結果から、種結晶プロセスにおけるH2流量の最適化、すなわち種結晶の結晶性や配向性を高めることが、その後の成長プロセスにおける薄膜全体の構造、特に結晶性と配向性に非常に大きな影響を与えることが明らかになりました。これは、エピタキシャルライクな成長を実現するためには、種結晶の品質が極めて重要であることを示唆するものです。

## 7. まとめ（スライド14）

本研究のまとめです。

*   我々は、二段階成長法において、種結晶プロセスと成長プロセスのそれぞれでガス流量を精密に制御することにより、製膜初期のアモルファス層の形成を抑制し、エピタキシャルライクな良好な界面構造を実現できることを明らかにしました。特に、成長プロセスでのH2流量の増大が界面の改善に大きく寄与することを見出しました。
*   また、種結晶の構造や結晶性が、その上に成長する最終的な多結晶シリコン薄膜の構造に大きく影響を与えることが分かりました。種結晶プロセスの条件を最適化し、より高結晶性の種結晶を形成することで、全体の薄膜の結晶性および配向性を向上させることが可能であることが示されました。

今後は、これらの知見に基づき、より高品質な多結晶シリコン薄膜を、低温かつ高速で安定して作製するための条件をさらに最適化し、実際に作製した薄膜の電気特性評価を進めていく予定です。

ご清聴いただき、誠にありがとうございました。