Good morning/afternoon, everyone. My name is [Your Name], a Ph.D. student from Tokyo Institute of Technology. It is a great honor to present our research here at the MRS meeting. Today, I will be talking about the "Fabrication of Polycrystalline Silicon Thin Films by a Two-Step Growth Method." Here is an outline of my presentation.

---

**[Slide 2: Background]**

Our group has successfully reported the fabrication of highly crystalline polycrystalline silicon thin films at low temperatures, specifically below 400°C, by using SiF4 gas as a source material, instead of the more commonly used SiH4. This method also achieves a high growth rate of approximately 10 Å/s, and the resulting films exhibit a high preferred orientation, typically (022). These films are expected to show excellent properties, particularly for vertical devices like solar cells.

However, when using inexpensive substrates such as glass, a major challenge arises: the formation of an amorphous phase immediately after deposition, which can significantly degrade the film properties. This issue can be addressed by the Layer-By-Layer (LBL) method, which involves repeating atomic hydrogen treatment after every few tens of angstroms of deposition. However, the LBL method reduces the effective growth rate, making it less practical for real-world industrial applications.

Furthermore, to use substrates like glass or plastic films, or to suppress diffusion at device interfaces, it is necessary to lower the growth temperature as much as possible. To overcome these challenges, we have proposed a two-step growth method.

---

**[Slide 3: Two-Step Growth Method]**

In the two-step growth method, we first create a high-quality seed layer using the LBL method at a relatively high temperature, typically around 380°C. This seed layer, typically about 100 nm thick, is designed to have high preferred orientation and high crystallinity. We refer to this as the "seed layer process."

On top of this seed layer, polycrystalline silicon is then grown epitaxially-like using a continuous deposition method. This allows for a higher effective growth rate and is performed at lower temperatures, typically ranging from 200 to 350°C. We call this the "growth process."

While we aim to lower the substrate temperature as much as possible in the growth process, there is a concern that if the interface structure between the seed layer and the grown film changes discontinuously due to varying substrate temperatures, the film properties may degrade. This is a critical aspect we need to control.

---

**[Slide 4: Previous Work: Impact of Air Exposure]**

This slide shows the in-situ ellipsometry observation results of the growth process reported by Miyamoto et al. last year. When the growth process was performed in a separate chamber after preparing the seed layer and exposing it to ambient air, a significant dip was observed in the pseudo-dielectric function, `<ε2>`, trajectory measured by the ellipsometer at the very beginning of the growth process. This dip is attributed to surface contamination caused by air exposure, which inevitably forms an amorphous layer or increases surface roughness. Consequently, as shown in the previous study, satisfactory solar cell characteristics could not be obtained. Thus, improving and controlling the interface in two-step growth is crucial for enhancing the overall film properties and device performance.

---

**[Slide 5: Objective]**

Therefore, the objective of this study was twofold. First, we aimed to investigate how to achieve a continuous and smooth epitaxial-like interface between the seed layer and the subsequently grown polycrystalline film. We utilized in-situ spectroscopic ellipsometry for real-time observation and control. Second, we aimed to systematically examine how the initial structure and crystallinity of the seed layer influences the final structure of the overall thin film.

---

**[Slide 6: Experimental Setup]**

This is a schematic diagram of the microwave plasma-enhanced CVD system used in this study. We use SiF4 as the source gas, and H2 and Ar as dilution gases. In our setup, H2 and Ar gases are introduced separately from SiF4 through a stainless steel tube, excited by microwave plasma, and then mixed with SiF4 to decompose it. The deposition and atomic hydrogen treatment processes in the Layer-By-Layer (LBL) method are precisely controlled by intermittently introducing SiF4 gas using a sequencer. This system is also conveniently equipped with an in-situ spectroscopic ellipsometer for real-time, non-destructive observation of film growth and surface evolution.

---

**[Slide 7: Experimental Method]**

Here, I summarize our typical deposition conditions. The microwave power was consistently set to 200 W, and the reaction pressure to 400 mTorr. For the LBL process during the seed layer stage, both the SiF4 deposition time and the atomic hydrogen treatment time were set to 10 seconds. The substrate temperature for the seed layer process was maintained at 380°C, which ensures high crystallinity. For the subsequent growth process, the substrate temperature was varied from 220°C to 380°C to investigate temperature dependence. During these experiments, we primarily varied the SiF4/H2 flow ratio in each process as a critical parameter.

The structure of the resulting thin films was evaluated using spectroscopic ellipsometry (SE) for detailed analysis of the film growth and interface, and X-ray diffraction (XRD) for overall crystallinity and preferred orientation. For real-time monitoring of the deposition process, we focused on the change in the pseudo-dielectric function, `<ε2>`, specifically at 4.15 eV, which is highly sensitive to the film's structural quality and surface roughness.

---

**[Slide 8: Evolution of <ε2> during Growth Process (Same Flow Ratio)]**

This graph shows the change in the pseudo-dielectric function, `<ε2>`, measured by ellipsometry during the growth process. The growth process officially begins at the point marked by the vertical line, and the region to the left represents the `<ε2>` of the seed layer. As a reminder, `<ε2>` is highly sensitive to the surface structure of the thin film; a decrease in `<ε2>` generally indicates a reduction in film crystallinity or an increase in surface roughness, often due to amorphous phase formation.

In this experiment, the growth process was performed immediately after the seed layer fabrication, without exposing it to air. As expected, we did not observe the deep dip that was previously attributed to air exposure. However, even with this continuous process, when we reduced the growth temperature to just 350°C, we observed a rapid decrease in `<ε2>`, as indicated by the blue line. This clearly suggests that an abrupt structural change is occurring at the interface between the seed layer and the grown film, leading to degradation even at slightly lower temperatures.

---

**[Slide 9: Evolution of <ε2> during Growth Process (Increased SiF4 in Seed Process)]**

Next, to compensate for the detrimental effect of temperature reduction, we investigated how the interface changes by varying the gas flow rates between the seed layer process and the growth process. Specifically, we first increased the SiF4 flow rate in the seed layer process, aiming for a higher crystallinity seed layer, and then reduced the SiF4 flow rate in the subsequent growth process. This effectively makes the SiF4/H2 ratio in the seed layer process higher than in the growth process.

As a result, as shown by the curves, even at a substrate temperature of 350°C, the `<ε2>` value changed much more continuously at the interface, indicating a significant improvement in the interface structure compared to the previous slide where the flow ratios were the same. However, we still observed a significant drop in `<ε2>` when the growth temperature was further reduced to 320°C, suggesting that additional optimization is needed for even lower temperatures.

---

**[Slide 10: Evolution of <ε2> during Growth Process (Controlled H2 Flow)]**

Building on the previous results, we further optimized the gas flow conditions. This time, we increased the H2 flow rate in the growth process, which means we significantly lowered the SiF4/H2 ratio in the growth process compared to the seed layer process. The aim here was to enhance the hydrogen etching effect during growth, which promotes crystallinity even at lower temperatures.

As shown by the curves on this slide, with this new optimized gas flow control, the interface structure remained smoothly connected even at temperatures as low as 280°C. Furthermore, we observed that no significant `<ε2>` drop occurred even with continued film growth at these lower temperatures. This is a very promising result.

These findings clearly demonstrate that by first fabricating the seed layer under conditions with a relatively higher SiF4/H2 flow ratio, and then performing the growth process with a significantly lower SiF4/H2 flow ratio, it is possible to achieve two-step growth with a continuous and high-quality interface, even at remarkably lower substrate temperatures.

---

**[Slide 11: Influence of Seed Layer on the Structure of Films Fabricated by Two-Step Growth Method]**

Now, I would like to shift our focus to the second objective of this study: investigating how the initial structure of the seed layer affects the final properties and structure of the subsequently grown thin film in the two-step growth method.

---

**[Slide 12: Seed Layer Dependence of <ε2> Change during Growth Process]**

This graph shows the change in `<ε2>` during the growth process under identical growth conditions, but with two different types of seed layers. The seed layer on the right, labeled "Seed: 60/10/60," exhibits a smaller initial `<ε2>` value, which indicates that it is a more amorphous-rich seed layer compared to the "Seed: 60/5/60" on the left, which has higher crystallinity.

When the films were grown at higher temperatures, we observed no significant difference in the `<ε2>` trajectories between these two cases, suggesting that at high temperatures, the growth conditions dominate over the initial seed layer quality to some extent. However, a clear divergence emerged at 280°C and below. For the amorphous-rich seed layer (right panel), a much larger and more rapid decrease in `<ε2>` was observed during the growth process compared to the crystalline seed layer (left panel). This indicates a significant degradation of crystallinity and increased surface roughness for films grown on an amorphous-rich seed layer at lower temperatures.

---

**[Slide 13: Influence of Seed Layer on the Structure of Films Fabricated by Two-Step Growth Method (SE, XRD Comparison)]**

To further confirm these observations, we performed ex-situ analysis of the final film structures using both spectroscopic ellipsometry (SE) and X-ray diffraction (XRD). The graphs presented here clearly show that the films grown on different seed layers exhibit distinctly different final structures, particularly at lower growth temperatures. For the film grown at 280°C and below on the amorphous-rich seed layer, the XRD patterns show almost no crystalline peaks, indicating a predominantly amorphous structure. In contrast, the film grown on the crystalline seed layer still exhibits clear diffraction peaks, confirming its polycrystalline nature.

These results unequivocally demonstrate that if the initial seed layer is amorphous-rich, the structure of the film subsequently grown on top of it will largely reflect the seed layer's structure, becoming amorphous-rich, especially when grown at lower temperatures. This highlights the critical importance of a high-quality, crystalline seed layer for achieving high-quality polycrystalline films using the two-step growth method, particularly when targeting low-temperature processing.

---

**[Slide 14: Summary]**

In summary, we have made two key findings in this study:
First, we successfully achieved a continuous and smooth interface structure between the seed layer and the growth layer by precisely controlling the gas flow rates, specifically the SiF4/H2 ratio, in both the seed layer process and the subsequent growth process. This approach allows for lower temperature growth while maintaining interface integrity.
Second, we clearly demonstrated that the initial structure and crystallinity of the seed layer significantly influence the final structure of the thin film, especially when the growth temperature is reduced. A high-quality crystalline seed layer is essential for obtaining high-quality polycrystalline films.

These findings provide crucial insights for developing highly efficient and cost-effective low-temperature polycrystalline silicon thin film devices. Thank you for your attention. I am happy to take any questions you may have.