# Slide 1: Fabrication of Polycrystalline Silicon Thin Films by a Two-Step Growth Method

## Text
Fabrication of Polycrystalline Silicon Thin Films by a Two-Step Growth Method
– Controlling Structure and Properties through Surface Reaction Control –
(T. Kamiya, K. Nakahata, J. Mitsuida, H. Lu, C. M. Fortmann, I. Shimizu, Tokyo Institute of Technology)

## Outline
*   Background
*   Two-Step Growth Method
*   Experimental Results
    *   Interface Structure (Ellipsometry)
    *   Influence of Seed Layer
*   Summary

## Diagram Text
Substrate
Seed crystal
poly-Si grain

---

# Slide 2: Background

## Text
Fabrication of Polycrystalline Silicon Thin Films by PE-CVD Method Using SiF4 Source Gas
*   Highly crystalline polycrystalline silicon at low temperatures
*   High deposition rate (~10 Å/s)
*   High preferred orientation (022)

Deposition on glass substrates: Need to reduce initial amorphous layer
*   Layer-By-Layer (LBL) Method
*   Two-Step Growth Method

---

# Slide 3: Two-Step Growth Method

## Text
## Growth Process
Substrate
Epitaxial-like growth
Low-temperature deposition (200~350°C)
High deposition rate
poly-Si

## Seed Layer Process
Substrate
Seed crystal (~100nm)
High preferred orientation
High crystallinity
High-temperature deposition (Ts > 360°C)
Layer-By-Layer Method

---

# Slide 4: Previous Work: Impact of Air Exposure

## Text
宮本さんデータ (Miyamoto et al.'s data)

<e2>
Time (sec)
on P-doped poly-Si
SiF4 50 sccm
SiF4 40 sccm
SiF4 30 sccm

## 図
![スライド4の図1](images\slide4_image1.png)
![スライド4の図2](images\slide4_image2.png)
![スライド4の図3](images\slide4_image3.png)
![スライド4の図4](images\slide4_image4.png)
![スライド4の図5](images\slide4_image5.png)
![スライド4の図6](images\slide4_image6.png)
![スライド4の図7](images\slide4_image7.png)
![スライド4の図8](images\slide4_image8.png)
![スライド4の図9](images\slide4_image9.png)
![スライド4の図10](images\slide4_image10.png)
![スライド4の図11](images\slide4_image11.png)
![スライド4の図12](images\slide4_image12.png)
![スライド4の図13](images\slide4_image13.png)
![スライド4の図14](images\slide4_image14.png)
![スライド4の図15](images\slide4_image15.x-wmf)
![スライド4の図16](images\slide4_image16.x-wmf)

---

# Slide 5: Objective

## Text
## Objective
*   To achieve an epitaxial-like interface between the seed layer and the grown polycrystalline thin film in the two-step growth method.
*   To investigate the influence of the seed layer crystallinity on the final film structure in the two-step growth method.

---

# Slide 6: Experimental Setup

## Text
## Experimental Setup
Modulator
Susceptor
MBP (Microwave Plasma)
Auto Vacuum Controller
Ar/H2
SiF4
Shutter
in-situ Spectroscopic Ellipsometer
Substrate
Light source
Controlled by Sequencer
Layer-By-Layer Method
H2
SiF4
Process time
Gas flow
Deposition
Atomic Hydrogen Treatment
Crystallinity Promotion
Detector
Magnet

---

# Slide 7: Experimental Method

## Text
## Experimental Method
### Structural Evaluation:
*   Spectroscopic Ellipsometer (SE)
*   Powder X-ray Diffraction (XRD)

### Observation of deposition process:
*   Ellipsometer (<ε2> at 4.15eV)

### Typical Deposition Conditions (Table placeholder)

## 図
![スライド7の図1](images\slide7_image1.x-emf)
![スライド7の図2](images\slide7_image2.x-emf)

---

# Slide 8: Evolution of <ε2> during Growth Process

## Text
## Evolution of <ε2> during Growth Process
(SiF4/H2 : Same for Seed Layer Process and Growth Process)
(Seed: 50/5/30, 380°C - poly-Si: 50/5/30)

## 図
![スライド8の図1](images\slide8_image1.x-emf)

---

# Slide 9: Evolution of <ε2> during Growth Process

## Text
## Evolution of <ε2> during Growth Process
(SiF4/H2 : Increased SiF4 flow rate in Seed Layer Process)
(Seed: 50/5/60, 380°C - poly-Si: 50/5/30)

## 図
![スライド9の図1](images\slide9_image1.x-wmf)

---

# Slide 10: Evolution of <ε2> during Growth Process

## Text
## Evolution of <ε2> during Growth Process
(SiF4/H2 : Further increased H2 flow rate in Growth Process)
(Seed: 60/5/60, 380°C - poly-Si: 60/10/30)

## 図
![スライド10の図1](images\slide10_image1.x-wmf)

---

# Slide 11: Influence of Seed Layer on the Structure of Films Fabricated by Two-Step Growth Method

## Text
## Influence of Seed Layer on the Structure of Films Fabricated by Two-Step Growth Method

## 図
![スライド11の図1](images\slide11_image1.x-wmf)

---

# Slide 12: Seed Layer Dependence of <ε2> Change during Growth Process

## Text
## Seed Layer Dependence of <ε2> Change during Growth Process
Seed: 60/5/60
Seed: 60/10/60
(poly-Si: 60/10/60)

## 図
![スライド12の図1](images\slide12_image1.x-wmf)
![スライド12の図2](images\slide12_image2.x-wmf)

---

# Slide 13: Influence of Seed Layer on the Structure of Films Fabricated by Two-Step Growth Method (SE, XRD Comparison)

## Text
## Influence of Seed Layer on the Structure of Films Fabricated by Two-Step Growth Method
Seed: 60/5/60
Seed: 60/10/60
Diffraction intensity / counts
<ε2>
(poly-Si: 60/10/60)

## 図
![スライド13の図1](images\slide13_image1.x-wmf)
![スライド13の図2](images\slide13_image2.x-wmf)
![スライド13の図3](images\slide13_image3.x-wmf)
![スライド13の図4](images\slide13_image4.x-wmf)

---

# Slide 14: Summary

## Text
## Summary
*   Achieved improved and continuous interface structure by controlling gas flow rates in both seed layer and growth processes.
*   Found that the structure of the seed layer significantly influences the final film structure, especially at lower growth temperatures.

---